/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.item.tool;

import com.archaeological_research.exploration.register.ModEntities;
import com.archaeological_research.exploration.register.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrowableTorchIE
extends ThrowableItemProjectile {
    public ThrowableTorchIE(EntityType<? extends ThrowableTorchIE> entityType, Level level) {
        super(entityType, level);
    }

    public ThrowableTorchIE(Level level, LivingEntity shooter) {
        super(ModEntities.THROWABLE_TORCH.get(), shooter, level);
    }

    public ThrowableTorchIE(Level level, double x, double y, double z) {
        super(ModEntities.THROWABLE_TORCH.get(), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.THROWABLE_TORCH.get();
    }

    private ParticleOptions getParticle() {
        ItemStack itemstack = this.getItem();
        return new ItemParticleOption(ParticleTypes.ITEM, itemstack);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        entity.setRemainingFireTicks(100);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            if (result.getType() == HitResult.Type.BLOCK) {
                BlockPos pos = result.getBlockPos();
                Direction side = result.getDirection();
                BlockState state = side.getAxis().isVertical() ? Blocks.TORCH.defaultBlockState() : (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)side);
                Entity entity = this.getOwner();
                if (entity != null) {
                    Level level = entity.level();
                    level.setBlockAndUpdate(pos.relative(side), state);
                }
                this.discard();
            }
        }
    }
}

