/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.item.tool;

import com.archaeological_research.exploration.item.tool.ThrowableTorchIE;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public class ThrowableTorchItem
extends Item
implements ProjectileItem {
    public ThrowableTorchItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            ThrowableTorchIE entity = new ThrowableTorchIE(level, (LivingEntity)player);
            entity.setItem(itemstack);
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)entity);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        itemstack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        ThrowableTorchIE entity = new ThrowableTorchIE(level, pos.x(), pos.y(), pos.z());
        entity.setItem(stack);
        return entity;
    }
}

