/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.register;

import com.archaeological_research.exploration.register.ModItems;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ModArmorMaterials {
    public static final Holder<ArmorMaterial> PALM_FIBER = ModArmorMaterials.register("palm_fiber", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 1);
        attribute.put(ArmorItem.Type.LEGGINGS, 2);
        attribute.put(ArmorItem.Type.CHESTPLATE, 2);
        attribute.put(ArmorItem.Type.HELMET, 1);
    }), 10, 0.0f, 0.0f, ModItems.PALM_FIBER);
    public static final Holder<ArmorMaterial> ANCIENT_ALLOY = ModArmorMaterials.register("ancient_alloy", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 1);
        attribute.put(ArmorItem.Type.LEGGINGS, 4);
        attribute.put(ArmorItem.Type.CHESTPLATE, 5);
        attribute.put(ArmorItem.Type.HELMET, 2);
    }), 25, 1.0f, 0.05f, ModItems.ANCIENT_ALLOY_INGOT);

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> material, int enchantability, float toughness, float knockbackResistance, Supplier<Item> ingredientItem) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"archaeological_research_exploration", (String)name);
        Holder equipSound = SoundEvents.ARMOR_EQUIP_NETHERITE;
        Supplier<Ingredient> ingredient = () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingredientItem.get()});
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(resourceLocation));
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(material);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, material.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)resourceLocation, (Object)new ArmorMaterial(material, enchantability, equipSound, ingredient, layers, toughness, knockbackResistance));
    }
}

