/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.world.event;

import com.archaeological_research.exploration.register.ModEffects;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="archaeological_research_exploration")
public class LivingDamageEvents {
    private static final Map<ResourceKey<DamageType>, Holder<MobEffect>> DAMAGE_EFFECT_MAP = new HashMap<ResourceKey<DamageType>, Holder<MobEffect>>();
    private static final Map<TagKey<DamageType>, Holder<MobEffect>> DAMAGE_TAGS_EFFECT_MAP;

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        for (ResourceKey<DamageType> resourceKey : DAMAGE_EFFECT_MAP.keySet()) {
            if (!source.is(resourceKey) || !entity.hasEffect(DAMAGE_EFFECT_MAP.get(resourceKey))) continue;
            event.setNewDamage(0.0f);
        }
        for (TagKey tagKey : DAMAGE_TAGS_EFFECT_MAP.keySet()) {
            if (!source.is(tagKey) || !entity.hasEffect(DAMAGE_TAGS_EFFECT_MAP.get(tagKey))) continue;
            event.setNewDamage(0.0f);
        }
    }

    static {
        DAMAGE_EFFECT_MAP.put((ResourceKey<DamageType>)DamageTypes.ARROW, ModEffects.ARROW_EVASION);
        DAMAGE_TAGS_EFFECT_MAP = new HashMap<TagKey<DamageType>, Holder<MobEffect>>();
        DAMAGE_TAGS_EFFECT_MAP.put((TagKey<DamageType>)DamageTypeTags.IS_EXPLOSION, ModEffects.COMPOSURE);
    }
}

