/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.world.modifier;

import com.archaeological_research.exploration.register.ModItems;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class EntityDropModifiers
extends LootModifier {
    public static final MapCodec<EntityDropModifiers> CODEC = RecordCodecBuilder.mapCodec(instance -> EntityDropModifiers.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, EntityDropModifiers::new));

    public EntityDropModifiers(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (entity instanceof Cow || entity instanceof Horse || entity instanceof AbstractChestedHorse) {
            generatedLoot.removeIf(itemStack -> itemStack.is(Items.LEATHER));
            generatedLoot.add((Object)new ItemStack((ItemLike)ModItems.PELT.get(), 1));
        }
        if (entity instanceof IronGolem) {
            generatedLoot.clear();
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

