/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building;

import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig {
    private static final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    public static final Visuals visuals = new Visuals(builder);
    public static final Performance performance = new Performance(builder);
    public static final ModConfigSpec spec = builder.build();

    public static class Visuals {
        public final ModConfigSpec.BooleanValue showBlockPreviews;
        public final ModConfigSpec.BooleanValue onlyShowBlockPreviewsWhenBuilding;
        public final ModConfigSpec.IntValue maxBlockPreviews;
        public final ModConfigSpec.IntValue appearAnimationLength;
        public final ModConfigSpec.IntValue breakAnimationLength;
        public final ModConfigSpec.DoubleValue previewScale;

        public Visuals(ModConfigSpec.Builder builder) {
            builder.push("Visuals");
            this.showBlockPreviews = builder.comment(new String[]{"Show previews of the blocks while placing them.", "Disable for better performance on low-end systems."}).define("showBlockPreviews", true);
            this.onlyShowBlockPreviewsWhenBuilding = builder.comment(new String[]{"Show block previews only when actively using a build mode.", "Reduces visual clutter when not building."}).define("onlyShowBlockPreviewsWhenBuilding", true);
            this.maxBlockPreviews = builder.comment(new String[]{"Don't show individual block previews when placing more than this many blocks.", "The outline will always be rendered regardless of this setting.", "Lower values improve performance for large builds."}).defineInRange("maxBlockPreviews", 400, 0, 5000);
            this.appearAnimationLength = builder.comment(new String[]{"How long it takes for a block to appear when placed in ticks.", "Set to 0 to disable animation for better performance.", "20 ticks = 1 second"}).defineInRange("appearAnimationLength", 5, 0, 100);
            this.breakAnimationLength = builder.comment(new String[]{"How long the break animation is in ticks.", "Set to 0 to disable animation for better performance.", "20 ticks = 1 second"}).defineInRange("breakAnimationLength", 10, 0, 100);
            this.previewScale = builder.comment(new String[]{"The scale of the ghost block previews.", "1.0 is full size, 0.5 is half size, etc.", "Smaller values reduce visual clutter."}).defineInRange("previewScale", 0.25, 0.05, 1.0);
            builder.pop();
        }
    }

    public static class Performance {
        public final ModConfigSpec.IntValue previewRenderDistance;
        public final ModConfigSpec.BooleanValue enableUpdateThrottling;

        public Performance(ModConfigSpec.Builder builder) {
            builder.comment(new String[]{"Performance settings for Sophisticated Building.", "Adjust these if experiencing lag or frame drops."}).push("Performance");
            this.previewRenderDistance = builder.comment(new String[]{"Maximum distance in blocks to render block previews.", "Blocks beyond this distance won't show individual previews.", "Lower values improve performance for large builds."}).defineInRange("previewRenderDistance", 64, 16, 256);
            this.enableUpdateThrottling = builder.comment(new String[]{"Enable update throttling to reduce CPU usage when idle.", "When enabled, calculations are skipped if the player hasn't moved.", "Disable if experiencing issues with preview updates."}).define("enableUpdateThrottling", true);
            builder.pop();
        }
    }
}

