/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.buildmode.BuildModeEnum;
import sophisticated.building.buildmode.ModeOptions;
import sophisticated.building.gui.buildmode.PlayerSettingsGui;
import sophisticated.building.gui.buildmode.RadialMenu;
import sophisticated.building.gui.buildmodifier.ModifiersScreen;

@EventBusSubscriber(modid="sophisticatedbuilding", value={Dist.CLIENT})
public class ClientEvents {
    public static KeyMapping[] keyBindings;
    public static int ticksInGame;
    private static int placeCooldown;
    private static int breakCooldown;

    @SubscribeEvent
    public static void onClientTickPre(ClientTickEvent.Pre event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        SophisticatedBuildingClient.BUILDER_CHAIN.onTick();
        ClientEvents.onMouseInput();
        SophisticatedBuildingClient.BLOCK_PREVIEWS.onTick();
    }

    @SubscribeEvent
    public static void onClientTickPost(ClientTickEvent.Post event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        Screen gui = Minecraft.getInstance().screen;
        if (gui == null || !gui.isPauseScreen()) {
            ++ticksInGame;
        }
    }

    private static void onMouseInput() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        BuildModeEnum buildMode = SophisticatedBuildingClient.BUILD_MODES.getBuildMode();
        if (mc.screen != null || RadialMenu.instance.isVisible()) {
            return;
        }
        if (mc.options.keyUse.isDown()) {
            if (placeCooldown <= 0) {
                placeCooldown = 4;
                SophisticatedBuildingClient.BUILDER_CHAIN.onRightClick();
            } else if (buildMode == BuildModeEnum.SINGLE) {
                --placeCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    placeCooldown = 0;
                }
            }
        } else {
            placeCooldown = 0;
        }
        if (mc.options.keyAttack.isDown()) {
            if (breakCooldown <= 0) {
                breakCooldown = 4;
                SophisticatedBuildingClient.BUILDER_CHAIN.onLeftClick();
            } else if (buildMode == BuildModeEnum.SINGLE) {
                --breakCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    breakCooldown = 0;
                }
            }
        } else {
            breakCooldown = 0;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onKeyPress(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (keyBindings[0].isDown()) {
            if (!AttachmentHandler.isDisabled((Player)player)) {
                if (!RadialMenu.instance.isVisible()) {
                    Minecraft.getInstance().setScreen((Screen)RadialMenu.instance);
                }
            } else {
                SophisticatedBuilding.log((Player)player, "Build modes are disabled until your reach has increased. Increase your reach with craftable reach upgrades.");
            }
        }
        if (keyBindings[1].consumeClick()) {
            ClientEvents.openModifierSettings();
        }
        if (keyBindings[2].consumeClick()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.UNDO);
        }
        if (keyBindings[3].consumeClick()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.REDO);
        }
        if (keyBindings[4].consumeClick()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.PREVIOUS_BUILD_MODE);
        }
        if (keyBindings[5].consumeClick()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.DISABLE_BUILD_MODE_TOGGLE);
        }
    }

    public static void openModifierSettings() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (AttachmentHandler.isDisabled((Player)player)) {
            SophisticatedBuilding.log((Player)player, "Build modifiers are disabled until your power level has increased. Increase your power level by consuming certain items.");
        } else {
            mc.setScreen((Screen)new ModifiersScreen());
        }
    }

    public static void openPlayerSettings() {
        Minecraft mc = Minecraft.getInstance();
        mc.setScreen((Screen)new PlayerSettingsGui());
    }

    @SubscribeEvent
    public static void onGuiOpen(ScreenEvent.Opening event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            SophisticatedBuildingClient.BUILDER_CHAIN.cancel();
        }
    }

    public static boolean isKeybindDown(int keybindIndex) {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyBindings[keybindIndex].getKey().getValue());
    }

    public static boolean isGameActive() {
        return Minecraft.getInstance().level != null && Minecraft.getInstance().player != null;
    }

    static {
        ticksInGame = 0;
        placeCooldown = 0;
        breakCooldown = 0;
        keyBindings = new KeyMapping[6];
        ClientEvents.keyBindings[0] = new KeyMapping("key.sophisticatedbuilding.mode.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.getKey((int)342, (int)0), "key.sophisticatedbuilding.category");
        ClientEvents.keyBindings[1] = new KeyMapping("key.sophisticatedbuilding.hud.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.getKey((int)334, (int)0), "key.sophisticatedbuilding.category");
        ClientEvents.keyBindings[2] = new KeyMapping("key.sophisticatedbuilding.undo.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.getKey((int)90, (int)0), "key.sophisticatedbuilding.category");
        ClientEvents.keyBindings[3] = new KeyMapping("key.sophisticatedbuilding.redo.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.getKey((int)89, (int)0), "key.sophisticatedbuilding.category");
        ClientEvents.keyBindings[4] = new KeyMapping("key.sophisticatedbuilding.previous_build_mode.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "key.sophisticatedbuilding.category");
        ClientEvents.keyBindings[5] = new KeyMapping("key.sophisticatedbuilding.disable_build_mode_toggle.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "key.sophisticatedbuilding.category");
    }
}

