/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.attachment.PowerLevel;
import sophisticated.building.compatibility.CompatHelper;
import sophisticated.building.item.AbstractRandomizerBagItem;
import sophisticated.building.item.upgrade.BuildingUpgradeHelper;
import sophisticated.building.network.message.BackpackItemCountPacket;
import sophisticated.building.network.message.ModifierSettingsPacket;
import sophisticated.building.network.message.PowerLevelPacket;
import sophisticated.building.systems.ServerBuildState;
import sophisticated.building.utilities.PowerLevelCommand;

@EventBusSubscriber
public class CommonEvents {
    private static final Map<UUID, Map<Item, Integer>> LAST_BACKPACK_COUNTS = new HashMap<UUID, Map<Item, Integer>>();

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        PowerLevelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level.isClientSide) {
            return;
        }
        if (!level.dimension().equals(Level.OVERWORLD)) {
            return;
        }
        SophisticatedBuilding.SERVER_BLOCK_PLACER.tick();
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        if (SophisticatedBuilding.SERVER_BLOCK_PLACER.isPlacingOrBreakingBlocks()) {
            return;
        }
        if (!ServerBuildState.isLikeVanilla(player) && CommonEvents.isPlayerHoldingBlock(player)) {
            event.setCanceled(true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int slotIndex = 36 + serverPlayer.getInventory().selected;
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(serverPlayer.inventoryMenu.containerId, serverPlayer.inventoryMenu.incrementStateId(), slotIndex, serverPlayer.getInventory().getSelected()));
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Player player = event.getPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        if (SophisticatedBuilding.SERVER_BLOCK_PLACER.isPlacingOrBreakingBlocks()) {
            return;
        }
        PowerLevel powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL);
        if (!ServerBuildState.isLikeVanilla(player) && powerLevel.canBreakFar(player)) {
            event.setCanceled(true);
        }
    }

    private static boolean isPlayerHoldingBlock(Player player) {
        ItemStack currentItemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        return currentItemStack.getItem() instanceof BlockItem || CompatHelper.isItemBlockProxy(currentItemStack) && !player.isShiftKeyDown();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.getCommandSenderWorld().isClientSide) {
            return;
        }
        ServerBuildState.handleNewPlayer(player);
        ((ServerPlayer)player).connection.send((CustomPacketPayload)new ModifierSettingsPacket(player));
        PowerLevel powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL);
        ((ServerPlayer)player).connection.send((CustomPacketPayload)new PowerLevelPacket(powerLevel.getPowerLevel()));
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        if (original.hasData(SophisticatedBuilding.POWER_LEVEL)) {
            clone.setData(SophisticatedBuilding.POWER_LEVEL, (Object)((PowerLevel)original.getData(SophisticatedBuilding.POWER_LEVEL)));
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (event.getSlot() != EquipmentSlot.MAINHAND) {
            return;
        }
        ItemStack to = event.getTo();
        if (to.getItem() instanceof BlockItem) {
            BuildingUpgradeHelper.syncItemCount(player, to.getItem());
        } else {
            AbstractRandomizerBagItem bagItem;
            IItemHandler bagInventory;
            Item item = to.getItem();
            if (item instanceof AbstractRandomizerBagItem && (bagInventory = (bagItem = (AbstractRandomizerBagItem)item).getBagInventory(to)) != null) {
                List<ItemStack> templates = bagItem.getTemplates(bagInventory);
                for (ItemStack template : templates) {
                    BuildingUpgradeHelper.syncItemCount(player, template.getItem());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player instanceof FakePlayer) {
            return;
        }
        if (serverPlayer.level().isClientSide) {
            return;
        }
        if (serverPlayer.tickCount % 10 != 0) {
            return;
        }
        LinkedHashSet<Item> itemsToSync = new LinkedHashSet<Item>();
        ItemStack held = serverPlayer.getMainHandItem();
        if (held.getItem() instanceof BlockItem) {
            itemsToSync.add(held.getItem());
        } else {
            AbstractRandomizerBagItem bagItem;
            IItemHandler bagInventory;
            Item item2 = held.getItem();
            if (item2 instanceof AbstractRandomizerBagItem && (bagInventory = (bagItem = (AbstractRandomizerBagItem)item2).getBagInventory(held)) != null) {
                List<ItemStack> templates = bagItem.getTemplates(bagInventory);
                for (ItemStack template : templates) {
                    itemsToSync.add(template.getItem());
                }
            }
        }
        if (itemsToSync.isEmpty()) {
            return;
        }
        Map lastCounts = LAST_BACKPACK_COUNTS.computeIfAbsent(serverPlayer.getUUID(), k -> new HashMap());
        for (Item item3 : itemsToSync) {
            int count = BuildingUpgradeHelper.countBlockInBackpack((Player)serverPlayer, new ItemStack((ItemLike)item3));
            Integer last = (Integer)lastCounts.get(item3);
            if (last != null && last == count) continue;
            lastCounts.put(item3, count);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new BackpackItemCountPacket(BuiltInRegistries.ITEM.getKey((Object)item3), count), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        lastCounts.keySet().removeIf(item -> !itemsToSync.contains(item));
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.getCommandSenderWorld().isClientSide) {
            SophisticatedBuilding.log("PlayerLoggedOutEvent triggers on client side");
            return;
        }
        SophisticatedBuilding.UNDO_REDO.clear(player);
        LAST_BACKPACK_COUNTS.remove(player.getUUID());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.getCommandSenderWorld().isClientSide) {
            SophisticatedBuilding.log("PlayerRespawnEvent triggers on client side");
            return;
        }
        ServerBuildState.handleNewPlayer(player);
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.getCommandSenderWorld().isClientSide) {
            SophisticatedBuilding.log("PlayerChangedDimensionEvent triggers on client side");
            return;
        }
        SophisticatedBuilding.UNDO_REDO.clear(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PowerLevel powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL);
            if (powerLevel != null) {
                serverPlayer.connection.send((CustomPacketPayload)new PowerLevelPacket(powerLevel.getPowerLevel()));
            }
        }
    }

    public static class ModBusEvents {
    }
}

