/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerRegistry;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sophisticated.building.ClientConfig;
import sophisticated.building.CommonConfig;
import sophisticated.building.ServerConfig;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.attachment.PowerLevel;
import sophisticated.building.compatibility.CompatHelper;
import sophisticated.building.gui.BuildingUpgradeContainer;
import sophisticated.building.gui.DiamondRandomizerBagContainer;
import sophisticated.building.gui.GoldenRandomizerBagContainer;
import sophisticated.building.gui.OmegaRandomizerBagContainer;
import sophisticated.building.gui.RandomizerBagContainer;
import sophisticated.building.integration.SophisticatedBackpacksIntegration;
import sophisticated.building.item.AbstractRandomizerBagItem;
import sophisticated.building.item.CompressedBlockItem;
import sophisticated.building.item.DiamondRandomizerBagItem;
import sophisticated.building.item.GoldenRandomizerBagItem;
import sophisticated.building.item.OmegaRandomizerBagItem;
import sophisticated.building.item.PowerLevelItem;
import sophisticated.building.item.RandomizerBagItem;
import sophisticated.building.item.ReachUpgrade1Item;
import sophisticated.building.item.ReachUpgrade2Item;
import sophisticated.building.item.ReachUpgrade3Item;
import sophisticated.building.item.SingleItemLootModifier;
import sophisticated.building.item.upgrade.BuildingUpgradeWrapper;
import sophisticated.building.network.PacketHandler;
import sophisticated.building.proxy.ClientProxy;
import sophisticated.building.proxy.ServerProxy;
import sophisticated.building.systems.ItemUsageTracker;
import sophisticated.building.systems.ServerBlockPlacer;
import sophisticated.building.systems.UndoRedo;

@Mod(value="sophisticatedbuilding")
public class SophisticatedBuilding {
    public static final String MODID = "sophisticatedbuilding";
    public static final Logger logger = LogManager.getLogger();
    public static SophisticatedBuilding instance;
    public static final ServerBlockPlacer SERVER_BLOCK_PLACER;
    public static final UndoRedo UNDO_REDO;
    public static final ItemUsageTracker ITEM_USAGE_TRACKER;
    public static final UpgradeContainerType<BuildingUpgradeWrapper, BuildingUpgradeContainer> BUILDING_UPGRADE_CONTAINER_TYPE;
    private static final DeferredRegister.Items ITEMS;
    private static final DeferredRegister<MenuType<?>> CONTAINERS;
    private static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> LOOT_MODIFIERS;
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES;
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final DeferredItem<RandomizerBagItem> RANDOMIZER_BAG_ITEM;
    public static final DeferredItem<GoldenRandomizerBagItem> GOLDEN_RANDOMIZER_BAG_ITEM;
    public static final DeferredItem<DiamondRandomizerBagItem> DIAMOND_RANDOMIZER_BAG_ITEM;
    public static final DeferredItem<OmegaRandomizerBagItem> OMEGA_RANDOMIZER_BAG_ITEM;
    public static final DeferredItem<ReachUpgrade1Item> REACH_UPGRADE_1_ITEM;
    public static final DeferredItem<ReachUpgrade2Item> REACH_UPGRADE_2_ITEM;
    public static final DeferredItem<ReachUpgrade3Item> REACH_UPGRADE_3_ITEM;
    public static final DeferredItem<PowerLevelItem> MUSCLES_ITEM;
    public static final DeferredItem<PowerLevelItem> ELASTIC_HAND_ITEM;
    public static final DeferredItem<PowerLevelItem> BUILDING_TECHNIQUES_BOOK_ITEM;
    public static final DeferredItem<CompressedBlockItem> COMPRESSED_DIRT;
    public static final DeferredItem<CompressedBlockItem> COMPRESSED_COBBLESTONE;
    public static final DeferredItem<CompressedBlockItem> COMPRESSED_SAND;
    public static final DeferredItem<CompressedBlockItem> COMPRESSED_COBBLED_DEEPSLATE;
    public static final DeferredItem<Item> BUILDING_UPGRADE_1;
    public static final DeferredItem<Item> BUILDING_UPGRADE_2;
    public static final DeferredItem<Item> BUILDING_UPGRADE_3;
    public static final DeferredItem<Item> BUILDING_UPGRADE_4;
    public static final DeferredItem<Item> BUILDING_UPGRADE_OMEGA;
    private static final List<DeferredItem<Item>> BUILDING_UPGRADE_ITEMS;
    public static final Supplier<CreativeModeTab> CREATIVE_TAB;
    public static final Supplier<MenuType<RandomizerBagContainer>> RANDOMIZER_BAG_CONTAINER;
    public static final Supplier<MenuType<GoldenRandomizerBagContainer>> GOLDEN_RANDOMIZER_BAG_CONTAINER;
    public static final Supplier<MenuType<DiamondRandomizerBagContainer>> DIAMOND_RANDOMIZER_BAG_CONTAINER;
    public static final Supplier<MenuType<OmegaRandomizerBagContainer>> OMEGA_RANDOMIZER_BAG_CONTAINER;
    public static final Supplier<MapCodec<SingleItemLootModifier>> SINGLE_ITEM_LOOT_MODIFIER;
    public static final Supplier<AttachmentType<PowerLevel>> POWER_LEVEL;

    private static Item createBuildingUpgrade(int tier, int maxBlocks) {
        if (CompatHelper.isSophisticatedBackpacksLoaded()) {
            try {
                return SophisticatedBackpacksIntegration.createBuildingUpgrade(tier, maxBlocks);
            }
            catch (Exception | NoClassDefFoundError e) {
                logger.warn("Failed to create BuildingUpgradeItem, SophisticatedBackpacks may not be loaded properly: {}", (Object)e.getMessage());
            }
        }
        return new Item(new Item.Properties().stacksTo(1));
    }

    public SophisticatedBuilding(IEventBus modEventBus, ModContainer container, Dist dist) {
        instance = this;
        IEventBus forgeEventBus = NeoForge.EVENT_BUS;
        modEventBus.addListener(SophisticatedBuilding::setup);
        modEventBus.addListener(SophisticatedBuilding::registerCapabilities);
        modEventBus.addListener(PacketHandler::setupPackets);
        ITEMS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        LOOT_MODIFIERS.register(modEventBus);
        ATTACHMENT_TYPES.register(modEventBus);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.spec);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.spec);
        if (dist.isClient()) {
            container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.spec);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            SophisticatedBuildingClient.onConstructorClient(modEventBus, forgeEventBus);
        }
    }

    public static void setup(FMLCommonSetupEvent event) {
        CompatHelper.setup();
        if (CompatHelper.isSophisticatedBackpacksLoaded()) {
            event.enqueueWork(() -> {
                UpgradeContainerRegistry.register((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)((Item)BUILDING_UPGRADE_1.get())), BUILDING_UPGRADE_CONTAINER_TYPE);
                UpgradeContainerRegistry.register((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)((Item)BUILDING_UPGRADE_2.get())), BUILDING_UPGRADE_CONTAINER_TYPE);
                UpgradeContainerRegistry.register((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)((Item)BUILDING_UPGRADE_3.get())), BUILDING_UPGRADE_CONTAINER_TYPE);
                UpgradeContainerRegistry.register((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)((Item)BUILDING_UPGRADE_4.get())), BUILDING_UPGRADE_CONTAINER_TYPE);
                UpgradeContainerRegistry.register((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)((Item)BUILDING_UPGRADE_OMEGA.get())), BUILDING_UPGRADE_CONTAINER_TYPE);
            });
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof AbstractRandomizerBagItem) {
                AbstractRandomizerBagItem bagItem = (AbstractRandomizerBagItem)patt0$temp;
                return new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, bagItem.getInventorySize());
            }
            return null;
        }, new ItemLike[]{(ItemLike)RANDOMIZER_BAG_ITEM.get(), (ItemLike)GOLDEN_RANDOMIZER_BAG_ITEM.get(), (ItemLike)DIAMOND_RANDOMIZER_BAG_ITEM.get(), (ItemLike)OMEGA_RANDOMIZER_BAG_ITEM.get()});
    }

    public static <T extends AbstractContainerMenu> MenuType<T> registerContainer(IContainerFactory<T> fact) {
        return new MenuType(fact, FeatureFlags.REGISTRY.allFlags());
    }

    public static void log(String msg) {
        logger.info(msg);
    }

    public static void log(Player player, String msg) {
        SophisticatedBuilding.log(player, msg, false);
    }

    public static void log(Player player, String msg, boolean actionBar) {
        player.displayClientMessage((Component)Component.literal((String)msg), actionBar);
    }

    public static void logTranslate(Player player, String prefix, String translationKey, String suffix, boolean actionBar) {
        if (FMLEnvironment.dist.isClient()) {
            ClientProxy.logTranslate(player, prefix, translationKey, suffix, actionBar);
        } else {
            ServerProxy.logTranslate(player, prefix, translationKey, suffix, actionBar);
        }
    }

    public static void logError(String msg) {
        logger.error(msg);
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    static {
        SERVER_BLOCK_PLACER = new ServerBlockPlacer();
        UNDO_REDO = new UndoRedo();
        ITEM_USAGE_TRACKER = new ItemUsageTracker();
        BUILDING_UPGRADE_CONTAINER_TYPE = new UpgradeContainerType(BuildingUpgradeContainer::new);
        ITEMS = DeferredRegister.createItems((String)MODID);
        CONTAINERS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)MODID);
        LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)MODID);
        ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)MODID);
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)MODID);
        RANDOMIZER_BAG_ITEM = ITEMS.register("randomizer_bag", RandomizerBagItem::new);
        GOLDEN_RANDOMIZER_BAG_ITEM = ITEMS.register("golden_randomizer_bag", GoldenRandomizerBagItem::new);
        DIAMOND_RANDOMIZER_BAG_ITEM = ITEMS.register("diamond_randomizer_bag", DiamondRandomizerBagItem::new);
        OMEGA_RANDOMIZER_BAG_ITEM = ITEMS.register("omega_randomizer_bag", OmegaRandomizerBagItem::new);
        REACH_UPGRADE_1_ITEM = ITEMS.register("reach_upgrade1", ReachUpgrade1Item::new);
        REACH_UPGRADE_2_ITEM = ITEMS.register("reach_upgrade2", ReachUpgrade2Item::new);
        REACH_UPGRADE_3_ITEM = ITEMS.register("reach_upgrade3", ReachUpgrade3Item::new);
        MUSCLES_ITEM = ITEMS.register("muscles", PowerLevelItem::new);
        ELASTIC_HAND_ITEM = ITEMS.register("elastic_hand", PowerLevelItem::new);
        BUILDING_TECHNIQUES_BOOK_ITEM = ITEMS.register("building_techniques_book", PowerLevelItem::new);
        COMPRESSED_DIRT = ITEMS.register("compressed_dirt", CompressedBlockItem::new);
        COMPRESSED_COBBLESTONE = ITEMS.register("compressed_cobblestone", CompressedBlockItem::new);
        COMPRESSED_SAND = ITEMS.register("compressed_sand", CompressedBlockItem::new);
        COMPRESSED_COBBLED_DEEPSLATE = ITEMS.register("compressed_cobbled_deepslate", CompressedBlockItem::new);
        BUILDING_UPGRADE_1 = ITEMS.register("building_upgrade_1", () -> SophisticatedBuilding.createBuildingUpgrade(1, 32));
        BUILDING_UPGRADE_2 = ITEMS.register("building_upgrade_2", () -> SophisticatedBuilding.createBuildingUpgrade(2, 64));
        BUILDING_UPGRADE_3 = ITEMS.register("building_upgrade_3", () -> SophisticatedBuilding.createBuildingUpgrade(3, 128));
        BUILDING_UPGRADE_4 = ITEMS.register("building_upgrade_4", () -> SophisticatedBuilding.createBuildingUpgrade(4, 256));
        BUILDING_UPGRADE_OMEGA = ITEMS.register("building_upgrade_omega", () -> SophisticatedBuilding.createBuildingUpgrade(5, 2048));
        BUILDING_UPGRADE_ITEMS = new ArrayList<DeferredItem<Item>>();
        BUILDING_UPGRADE_ITEMS.add(BUILDING_UPGRADE_1);
        BUILDING_UPGRADE_ITEMS.add(BUILDING_UPGRADE_2);
        BUILDING_UPGRADE_ITEMS.add(BUILDING_UPGRADE_3);
        BUILDING_UPGRADE_ITEMS.add(BUILDING_UPGRADE_4);
        BUILDING_UPGRADE_ITEMS.add(BUILDING_UPGRADE_OMEGA);
        CREATIVE_TAB = CREATIVE_MODE_TABS.register("main", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)BUILDING_UPGRADE_OMEGA.get())).title((Component)Component.translatable((String)"itemGroup.sophisticatedbuilding")).displayItems((parameters, output) -> {
            output.accept((ItemLike)RANDOMIZER_BAG_ITEM.get());
            output.accept((ItemLike)GOLDEN_RANDOMIZER_BAG_ITEM.get());
            output.accept((ItemLike)DIAMOND_RANDOMIZER_BAG_ITEM.get());
            output.accept((ItemLike)OMEGA_RANDOMIZER_BAG_ITEM.get());
            output.accept((ItemLike)REACH_UPGRADE_1_ITEM.get());
            output.accept((ItemLike)REACH_UPGRADE_2_ITEM.get());
            output.accept((ItemLike)REACH_UPGRADE_3_ITEM.get());
            output.accept((ItemLike)MUSCLES_ITEM.get());
            output.accept((ItemLike)ELASTIC_HAND_ITEM.get());
            output.accept((ItemLike)BUILDING_TECHNIQUES_BOOK_ITEM.get());
            output.accept((ItemLike)COMPRESSED_DIRT.get());
            output.accept((ItemLike)COMPRESSED_COBBLESTONE.get());
            output.accept((ItemLike)COMPRESSED_SAND.get());
            output.accept((ItemLike)COMPRESSED_COBBLED_DEEPSLATE.get());
            for (DeferredItem<Item> upgradeItem : BUILDING_UPGRADE_ITEMS) {
                output.accept((ItemLike)upgradeItem.get());
            }
        }).build());
        RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("randomizer_bag", () -> SophisticatedBuilding.registerContainer(RandomizerBagContainer::new));
        GOLDEN_RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("golden_randomizer_bag", () -> SophisticatedBuilding.registerContainer(GoldenRandomizerBagContainer::new));
        DIAMOND_RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("diamond_randomizer_bag", () -> SophisticatedBuilding.registerContainer(DiamondRandomizerBagContainer::new));
        OMEGA_RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("omega_randomizer_bag", () -> SophisticatedBuilding.registerContainer(OmegaRandomizerBagContainer::new));
        SINGLE_ITEM_LOOT_MODIFIER = LOOT_MODIFIERS.register("single_item_loot_modifier", SingleItemLootModifier.CODEC);
        POWER_LEVEL = ATTACHMENT_TYPES.register("power_level", () -> AttachmentType.serializable(PowerLevel::new).build());
    }
}

