/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.attachment;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import sophisticated.building.CommonConfig;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.attachment.PowerLevel;
import sophisticated.building.network.message.PowerLevelPacket;

public class AttachmentHandler {
    public static final ResourceLocation POWER_LEVEL_CAP = SophisticatedBuilding.asResource("power_level");

    public static void syncToClient(Player player) {
        PowerLevel powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL);
        if (powerLevel == null) {
            return;
        }
        ((ServerPlayer)player).connection.send((CustomPacketPayload)new PowerLevelPacket(powerLevel.getPowerLevel()));
    }

    public static boolean canReplaceBlocks(Player player) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.canReplaceBlocks(player);
        }
        return false;
    }

    public static int getMaxBlocksPerAxis(Player player, boolean nextPowerLevel) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.getMaxBlocksPerAxis(player, nextPowerLevel);
        }
        return (Integer)CommonConfig.maxBlocksPerAxis.level0.get();
    }

    public static int getMaxBlocksPlacedAtOnce(Player player, boolean nextPowerLevel) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.getMaxBlocksPlacedAtOnce(player, nextPowerLevel);
        }
        return (Integer)CommonConfig.maxBlocksPlacedAtOnce.level0.get();
    }

    public static int getMaxMirrorRadius(Player player, boolean nextPowerLevel) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.getMaxMirrorRadius(player, nextPowerLevel);
        }
        return (Integer)CommonConfig.maxMirrorRadius.level0.get();
    }

    public static int getBuildModeReach(Player player) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.getBuildModeReach(player);
        }
        return (Integer)CommonConfig.maxMirrorRadius.level0.get() + 6;
    }

    public static int getPlacementReach(Player player, boolean nextPowerLevel) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.getPlacementReach(player, nextPowerLevel);
        }
        return (Integer)CommonConfig.reach.level0.get();
    }

    public static int getPowerLevel(Player player) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.getPowerLevel();
        }
        return 0;
    }

    public static int getNextPowerLevel(Player player) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.getNextPowerLevel();
        }
        return 0;
    }

    public static boolean canIncreasePowerLevel(Player player) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.canIncreasePowerLevel();
        }
        return false;
    }

    public static boolean isDisabled(Player player) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.isDisabled(player);
        }
        return false;
    }

    public static boolean canBreakFar(Player player) {
        PowerLevel powerLevel;
        if (player != null && (powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL)) != null) {
            return powerLevel.canBreakFar(player);
        }
        return false;
    }
}

