/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmode;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.buildmode.BuildModeEnum;
import sophisticated.building.network.message.IsUsingBuildModePacket;
import sophisticated.building.utilities.BlockSet;

@OnlyIn(value=Dist.CLIENT)
public class BuildModes {
    private BuildModeEnum buildMode = BuildModeEnum.DISABLED;
    private BuildModeEnum previousBuildMode = BuildModeEnum.DISABLED;
    private BuildModeEnum beforeDisabledBuildMode = BuildModeEnum.SINGLE;

    public void findCoordinates(BlockSet blocks, Player player) {
        this.buildMode.instance.findCoordinates(blocks);
    }

    public BuildModeEnum getBuildMode() {
        return this.buildMode;
    }

    public void setBuildMode(BuildModeEnum buildMode) {
        this.buildMode = buildMode;
        PacketDistributor.sendToServer((CustomPacketPayload)new IsUsingBuildModePacket(this.buildMode != BuildModeEnum.DISABLED), (CustomPacketPayload[])new CustomPacketPayload[0]);
        SophisticatedBuilding.log((Player)Minecraft.getInstance().player, I18n.get((String)buildMode.getNameKey(), (Object[])new Object[0]), true);
    }

    public void activatePreviousBuildMode() {
        BuildModeEnum temp = this.buildMode;
        this.setBuildMode(this.previousBuildMode);
        this.previousBuildMode = temp;
    }

    public void activateDisableBuildModeToggle() {
        if (this.buildMode == BuildModeEnum.DISABLED) {
            this.setBuildMode(this.beforeDisabledBuildMode);
        } else {
            this.beforeDisabledBuildMode = this.buildMode;
            this.setBuildMode(BuildModeEnum.DISABLED);
        }
    }

    public void onCancel() {
        this.getBuildMode().instance.initialize();
    }

    public static Vec3 findXBound(double x, Vec3 start, Vec3 look) {
        double y = (x - start.x) / look.x * look.y + start.y;
        double z = (x - start.x) / look.x * look.z + start.z;
        return new Vec3(x, y, z);
    }

    public static Vec3 findYBound(double y, Vec3 start, Vec3 look) {
        double x = (y - start.y) / look.y * look.x + start.x;
        double z = (y - start.y) / look.y * look.z + start.z;
        return new Vec3(x, y, z);
    }

    public static Vec3 findZBound(double z, Vec3 start, Vec3 look) {
        double x = (z - start.z) / look.z * look.x + start.x;
        double y = (z - start.z) / look.z * look.y + start.y;
        return new Vec3(x, y, z);
    }

    public static Vec3 getPlayerLookVec(Player player) {
        Vec3 lookVec = player.getLookAngle();
        double x = lookVec.x;
        double y = lookVec.y;
        double z = lookVec.z;
        if (Math.abs(x) < 1.0E-4) {
            x = 1.0E-4;
        }
        if (Math.abs(x - 1.0) < 1.0E-4) {
            x = 0.9999;
        }
        if (Math.abs(x + 1.0) < 1.0E-4) {
            x = -0.9999;
        }
        if (Math.abs(y) < 1.0E-4) {
            y = 1.0E-4;
        }
        if (Math.abs(y - 1.0) < 1.0E-4) {
            y = 0.9999;
        }
        if (Math.abs(y + 1.0) < 1.0E-4) {
            y = -0.9999;
        }
        if (Math.abs(z) < 1.0E-4) {
            z = 1.0E-4;
        }
        if (Math.abs(z - 1.0) < 1.0E-4) {
            z = 0.9999;
        }
        if (Math.abs(z + 1.0) < 1.0E-4) {
            z = -0.9999;
        }
        return new Vec3(x, y, z);
    }

    public static boolean isCriteriaValid(Vec3 start, Vec3 look, int reach, Player player, boolean skipRaytrace, Vec3 lineBound, Vec3 planeBound, double distToPlayerSq) {
        boolean intersects = false;
        if (!skipRaytrace) {
            ClipContext rayTraceContext = new ClipContext(start, lineBound, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult rayTraceResult = player.level().clip(rayTraceContext);
            intersects = rayTraceResult != null && rayTraceResult.getType() == HitResult.Type.BLOCK && planeBound.subtract(rayTraceResult.getLocation()).lengthSqr() > 4.0;
        }
        return planeBound.subtract(start).dot(look) > 0.0 && distToPlayerSq > 2.0 && distToPlayerSq < (double)(reach * reach) && !intersects;
    }
}

