/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmode;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import sophisticated.building.AllIcons;
import sophisticated.building.ClientEvents;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.network.message.PerformRedoPacket;
import sophisticated.building.network.message.PerformUndoPacket;
import sophisticated.building.systems.BuildSettings;

@OnlyIn(value=Dist.CLIENT)
public class ModeOptions {
    private static ActionEnum buildSpeed = ActionEnum.NORMAL_SPEED;
    private static ActionEnum fill = ActionEnum.FULL;
    private static ActionEnum cubeFill = ActionEnum.CUBE_FULL;
    private static ActionEnum raisedEdge = ActionEnum.SHORT_EDGE;
    private static ActionEnum lineThickness = ActionEnum.THICKNESS_1;
    private static ActionEnum circleStart = ActionEnum.CIRCLE_START_CORNER;

    public static ActionEnum getOptionSetting(OptionEnum option) {
        switch (option.ordinal()) {
            case 0: {
                return ModeOptions.getBuildSpeed();
            }
            case 1: {
                return ModeOptions.getFill();
            }
            case 2: {
                return ModeOptions.getCubeFill();
            }
            case 3: {
                return ModeOptions.getRaisedEdge();
            }
            case 4: {
                return ModeOptions.getLineThickness();
            }
            case 5: {
                return ModeOptions.getCircleStart();
            }
        }
        return null;
    }

    public static ActionEnum getBuildSpeed() {
        return buildSpeed;
    }

    public static ActionEnum getFill() {
        return fill;
    }

    public static ActionEnum getCubeFill() {
        return cubeFill;
    }

    public static ActionEnum getRaisedEdge() {
        return raisedEdge;
    }

    public static ActionEnum getLineThickness() {
        return lineThickness;
    }

    public static ActionEnum getCircleStart() {
        return circleStart;
    }

    public static void performAction(Player player, ActionEnum action) {
        if (action == null) {
            return;
        }
        switch (action.ordinal()) {
            case 0: {
                PacketDistributor.sendToServer((CustomPacketPayload)new PerformUndoPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case 1: {
                PacketDistributor.sendToServer((CustomPacketPayload)new PerformRedoPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case 2: {
                ClientEvents.openModifierSettings();
                break;
            }
            case 3: {
                ClientEvents.openPlayerSettings();
                break;
            }
            case 4: {
                SophisticatedBuildingClient.BUILD_MODES.activatePreviousBuildMode();
                break;
            }
            case 5: {
                SophisticatedBuildingClient.BUILD_MODES.activateDisableBuildModeToggle();
                break;
            }
            case 6: {
                SophisticatedBuildingClient.BUILD_SETTINGS.setReplaceMode(BuildSettings.ReplaceMode.ONLY_AIR);
                break;
            }
            case 7: {
                SophisticatedBuildingClient.BUILD_SETTINGS.setReplaceMode(BuildSettings.ReplaceMode.BLOCKS_AND_AIR);
                break;
            }
            case 8: {
                SophisticatedBuildingClient.BUILD_SETTINGS.setReplaceMode(BuildSettings.ReplaceMode.ONLY_BLOCKS);
                break;
            }
            case 9: {
                SophisticatedBuildingClient.BUILD_SETTINGS.setReplaceMode(BuildSettings.ReplaceMode.FILTERED_BY_OFFHAND);
                break;
            }
            case 10: {
                SophisticatedBuildingClient.BUILD_SETTINGS.toggleProtectTileEntities();
                break;
            }
            case 11: {
                buildSpeed = ActionEnum.NORMAL_SPEED;
                break;
            }
            case 12: {
                buildSpeed = ActionEnum.FAST_SPEED;
                break;
            }
            case 13: {
                fill = ActionEnum.FULL;
                break;
            }
            case 14: {
                fill = ActionEnum.HOLLOW;
                break;
            }
            case 15: {
                cubeFill = ActionEnum.CUBE_FULL;
                break;
            }
            case 16: {
                cubeFill = ActionEnum.CUBE_HOLLOW;
                break;
            }
            case 17: {
                cubeFill = ActionEnum.CUBE_SKELETON;
                break;
            }
            case 18: {
                raisedEdge = ActionEnum.SHORT_EDGE;
                break;
            }
            case 19: {
                raisedEdge = ActionEnum.LONG_EDGE;
                break;
            }
            case 20: {
                lineThickness = ActionEnum.THICKNESS_1;
                break;
            }
            case 21: {
                lineThickness = ActionEnum.THICKNESS_3;
                break;
            }
            case 22: {
                lineThickness = ActionEnum.THICKNESS_5;
                break;
            }
            case 24: {
                circleStart = ActionEnum.CIRCLE_START_CENTER;
                break;
            }
            case 23: {
                circleStart = ActionEnum.CIRCLE_START_CORNER;
            }
        }
        if (player.level().isClientSide && action != ActionEnum.OPEN_MODIFIER_SETTINGS && action != ActionEnum.OPEN_PLAYER_SETTINGS && action != ActionEnum.PREVIOUS_BUILD_MODE && action != ActionEnum.DISABLE_BUILD_MODE_TOGGLE) {
            SophisticatedBuilding.logTranslate(player, "", action.getNameKey(), "", true);
        }
    }

    public static enum OptionEnum {
        BUILD_SPEED("sophisticatedbuilding.action.build_speed", ActionEnum.NORMAL_SPEED, ActionEnum.FAST_SPEED),
        FILL("sophisticatedbuilding.action.filling", ActionEnum.FULL, ActionEnum.HOLLOW),
        CUBE_FILL("sophisticatedbuilding.action.filling", ActionEnum.CUBE_FULL, ActionEnum.CUBE_HOLLOW, ActionEnum.CUBE_SKELETON),
        RAISED_EDGE("sophisticatedbuilding.action.raised_edge", ActionEnum.SHORT_EDGE, ActionEnum.LONG_EDGE),
        LINE_THICKNESS("sophisticatedbuilding.action.thickness", ActionEnum.THICKNESS_1, ActionEnum.THICKNESS_3, ActionEnum.THICKNESS_5),
        CIRCLE_START("sophisticatedbuilding.action.circle_start", ActionEnum.CIRCLE_START_CORNER, ActionEnum.CIRCLE_START_CENTER);

        public String name;
        public ActionEnum[] actions;

        private OptionEnum(String name, ActionEnum ... actions) {
            this.name = name;
            this.actions = actions;
        }
    }

    public static enum ActionEnum {
        UNDO("undo", AllIcons.I_UNDO),
        REDO("redo", AllIcons.I_REDO),
        OPEN_MODIFIER_SETTINGS("open_modifier_settings", AllIcons.I_SETTINGS),
        OPEN_PLAYER_SETTINGS("open_player_settings", AllIcons.I_SETTINGS),
        PREVIOUS_BUILD_MODE("previous_build_mode", AllIcons.I_SINGLE),
        DISABLE_BUILD_MODE_TOGGLE("disable_build_mode_toggle", AllIcons.I_DISABLE),
        REPLACE_ONLY_AIR("replace_only_air", AllIcons.I_REPLACE_AIR),
        REPLACE_BLOCKS_AND_AIR("replace_blocks_and_air", AllIcons.I_REPLACE_BLOCKS_AND_AIR),
        REPLACE_ONLY_BLOCKS("replace_only_blocks", AllIcons.I_REPLACE_BLOCKS),
        REPLACE_FILTERED_BY_OFFHAND("replace_filtered_by_offhand", AllIcons.I_REPLACE_OFFHAND_FILTERED),
        TOGGLE_PROTECT_TILE_ENTITIES("toggle_protect_tile_entities", AllIcons.I_PROTECT_TILE_ENTITIES),
        NORMAL_SPEED("normal_speed", AllIcons.I_NORMAL_SPEED),
        FAST_SPEED("fast_speed", AllIcons.I_FAST_SPEED),
        FULL("full", AllIcons.I_FILLED),
        HOLLOW("hollow", AllIcons.I_HOLLOW),
        CUBE_FULL("full", AllIcons.I_CUBE_FILLED),
        CUBE_HOLLOW("hollow", AllIcons.I_CUBE_HOLLOW),
        CUBE_SKELETON("skeleton", AllIcons.I_CUBE_SKELETON),
        SHORT_EDGE("short_edge", AllIcons.I_SHORT_EDGE),
        LONG_EDGE("long_edge", AllIcons.I_LONG_EDGE),
        THICKNESS_1("thickness_1", AllIcons.I_THICKNESS_1),
        THICKNESS_3("thickness_3", AllIcons.I_THICKNESS_3),
        THICKNESS_5("thickness_5", AllIcons.I_THICKNESS_5),
        CIRCLE_START_CORNER("start_corner", AllIcons.I_CIRCLE_START_CORNER),
        CIRCLE_START_CENTER("start_center", AllIcons.I_CIRCLE_START_CENTER);

        public String name;
        public AllIcons icon;

        private ActionEnum(String name, AllIcons icon) {
            this.name = name;
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public String getNameKey() {
            return "sophisticatedbuilding.action." + this.name;
        }

        public String getDescriptionKey() {
            return "sophisticatedbuilding.action." + this.name + ".description";
        }
    }
}

