/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmode;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.buildmode.BaseBuildMode;
import sophisticated.building.buildmode.BuildModes;
import sophisticated.building.utilities.BlockEntry;
import sophisticated.building.utilities.BlockSet;

public abstract class ThreeClicksBuildMode
extends BaseBuildMode {
    protected BlockEntry firstBlockEntry;
    protected BlockEntry secondBlockEntry;

    @Override
    public void initialize() {
        super.initialize();
        this.firstBlockEntry = null;
        this.secondBlockEntry = null;
    }

    @Override
    public boolean onClick(BlockSet blocks) {
        super.onClick(blocks);
        if (this.clicks == 1) {
            this.firstBlockEntry = SophisticatedBuildingClient.BUILDER_CHAIN.getStartPos();
            if (this.firstBlockEntry == null) {
                this.clicks = 0;
            }
        } else if (this.clicks == 2) {
            if (blocks.size() == 0) {
                this.clicks = 0;
                return false;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            BlockPos secondPos = this.findSecondPos((Player)player, this.firstBlockEntry.blockPos, true);
            this.secondBlockEntry = new BlockEntry(secondPos);
        } else {
            this.clicks = 0;
            return true;
        }
        return false;
    }

    @Override
    public void findCoordinates(BlockSet blocks) {
        if (this.clicks == 0) {
            return;
        }
        if (this.clicks == 1) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (this.firstBlockEntry == null || this.firstBlockEntry.blockPos == null) {
                return;
            }
            BlockPos firstPos = this.firstBlockEntry.blockPos;
            BlockPos secondPos = this.findSecondPos((Player)player, this.firstBlockEntry.blockPos, true);
            if (secondPos == null) {
                return;
            }
            int axisLimit = AttachmentHandler.getMaxBlocksPerAxis((Player)player, false);
            int x1 = firstPos.getX();
            int x2 = secondPos.getX();
            int y1 = firstPos.getY();
            int y2 = secondPos.getY();
            int z1 = firstPos.getZ();
            int z2 = secondPos.getZ();
            if (x2 - x1 >= axisLimit) {
                x2 = x1 + axisLimit - 1;
            }
            if (x1 - x2 >= axisLimit) {
                x2 = x1 - axisLimit + 1;
            }
            if (y2 - y1 >= axisLimit) {
                y2 = y1 + axisLimit - 1;
            }
            if (y1 - y2 >= axisLimit) {
                y2 = y1 - axisLimit + 1;
            }
            if (z2 - z1 >= axisLimit) {
                z2 = z1 + axisLimit - 1;
            }
            if (z1 - z2 >= axisLimit) {
                z2 = z1 - axisLimit + 1;
            }
            blocks.clear();
            for (BlockPos pos : this.getIntermediateBlocks((Player)player, x1, y1, z1, x2, y2, z2)) {
                if (blocks.containsKey(pos)) continue;
                blocks.add(new BlockEntry(pos));
            }
            blocks.firstPos = firstPos;
            blocks.lastPos = secondPos;
        } else {
            LocalPlayer player = Minecraft.getInstance().player;
            if (this.firstBlockEntry == null || this.firstBlockEntry.blockPos == null) {
                return;
            }
            if (this.secondBlockEntry == null || this.secondBlockEntry.blockPos == null) {
                return;
            }
            BlockPos firstPos = this.firstBlockEntry.blockPos;
            BlockPos secondPos = this.secondBlockEntry.blockPos;
            BlockPos thirdPos = this.findThirdPos((Player)player, firstPos, secondPos, true);
            if (thirdPos == null) {
                return;
            }
            int axisLimit = AttachmentHandler.getMaxBlocksPerAxis((Player)player, false);
            int x1 = firstPos.getX();
            int x2 = secondPos.getX();
            int x3 = thirdPos.getX();
            int y1 = firstPos.getY();
            int y2 = secondPos.getY();
            int y3 = thirdPos.getY();
            int z1 = firstPos.getZ();
            int z2 = secondPos.getZ();
            int z3 = thirdPos.getZ();
            if (x2 - x1 >= axisLimit) {
                x2 = x1 + axisLimit - 1;
            }
            if (x1 - x2 >= axisLimit) {
                x2 = x1 - axisLimit + 1;
            }
            if (y2 - y1 >= axisLimit) {
                y2 = y1 + axisLimit - 1;
            }
            if (y1 - y2 >= axisLimit) {
                y2 = y1 - axisLimit + 1;
            }
            if (z2 - z1 >= axisLimit) {
                z2 = z1 + axisLimit - 1;
            }
            if (z1 - z2 >= axisLimit) {
                z2 = z1 - axisLimit + 1;
            }
            if (x3 - x1 >= axisLimit) {
                x3 = x1 + axisLimit - 1;
            }
            if (x1 - x3 >= axisLimit) {
                x3 = x1 - axisLimit + 1;
            }
            if (y3 - y1 >= axisLimit) {
                y3 = y1 + axisLimit - 1;
            }
            if (y1 - y3 >= axisLimit) {
                y3 = y1 - axisLimit + 1;
            }
            if (z3 - z1 >= axisLimit) {
                z3 = z1 + axisLimit - 1;
            }
            if (z1 - z3 >= axisLimit) {
                z3 = z1 - axisLimit + 1;
            }
            blocks.clear();
            for (BlockPos pos : this.getFinalBlocks((Player)player, x1, y1, z1, x2, y2, z2, x3, y3, z3)) {
                if (blocks.containsKey(pos)) continue;
                blocks.add(new BlockEntry(pos));
            }
            blocks.firstPos = firstPos;
            blocks.lastPos = thirdPos;
        }
    }

    public static BlockPos findHeight(Player player, BlockPos secondPos, boolean skipRaytrace) {
        Vec3 look = BuildModes.getPlayerLookVec(player);
        Vec3 start = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        ArrayList<HeightCriteria> criteriaList = new ArrayList<HeightCriteria>(3);
        Vec3 xBound = BuildModes.findXBound(secondPos.getX(), start, look);
        criteriaList.add(new HeightCriteria(xBound, secondPos, start));
        Vec3 zBound = BuildModes.findZBound(secondPos.getZ(), start, look);
        criteriaList.add(new HeightCriteria(zBound, secondPos, start));
        int reach = AttachmentHandler.getBuildModeReach(player);
        criteriaList.removeIf(criteria -> !criteria.isValid(start, look, reach, player, skipRaytrace));
        if (criteriaList.isEmpty()) {
            return null;
        }
        HeightCriteria selected = (HeightCriteria)criteriaList.get(0);
        if (criteriaList.size() > 1) {
            for (int i = 1; i < criteriaList.size(); ++i) {
                HeightCriteria criteria2 = (HeightCriteria)criteriaList.get(i);
                if (criteria2.distToLineSq < 2.0 && selected.distToLineSq < 2.0) {
                    if (!(criteria2.distToPlayerSq < selected.distToPlayerSq)) continue;
                    selected = criteria2;
                    continue;
                }
                if (!(criteria2.distToLineSq < selected.distToLineSq)) continue;
                selected = criteria2;
            }
        }
        return BlockPos.containing((Position)selected.lineBound);
    }

    protected abstract BlockPos findSecondPos(Player var1, BlockPos var2, boolean var3);

    protected abstract BlockPos findThirdPos(Player var1, BlockPos var2, BlockPos var3, boolean var4);

    protected abstract List<BlockPos> getIntermediateBlocks(Player var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract List<BlockPos> getFinalBlocks(Player var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    static class HeightCriteria {
        Vec3 planeBound;
        Vec3 lineBound;
        double distToLineSq;
        double distToPlayerSq;

        HeightCriteria(Vec3 planeBound, BlockPos secondPos, Vec3 start) {
            this.planeBound = planeBound;
            this.lineBound = this.toLongestLine(this.planeBound, secondPos);
            this.distToLineSq = this.lineBound.subtract(this.planeBound).lengthSqr();
            this.distToPlayerSq = this.planeBound.subtract(start).lengthSqr();
        }

        private Vec3 toLongestLine(Vec3 boundVec, BlockPos secondPos) {
            BlockPos bound = BlockPos.containing((Position)boundVec);
            return new Vec3((double)secondPos.getX(), (double)bound.getY(), (double)secondPos.getZ());
        }

        public boolean isValid(Vec3 start, Vec3 look, int reach, Player player, boolean skipRaytrace) {
            return BuildModes.isCriteriaValid(start, look, reach, player, skipRaytrace, this.lineBound, this.planeBound, this.distToPlayerSq);
        }
    }
}

