/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmode;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.buildmode.BaseBuildMode;
import sophisticated.building.utilities.BlockEntry;
import sophisticated.building.utilities.BlockSet;

public abstract class TwoClicksBuildMode
extends BaseBuildMode {
    protected BlockEntry firstBlockEntry;

    @Override
    public void initialize() {
        super.initialize();
        this.firstBlockEntry = null;
    }

    @Override
    public boolean onClick(BlockSet blocks) {
        super.onClick(blocks);
        if (this.clicks == 1) {
            this.firstBlockEntry = SophisticatedBuildingClient.BUILDER_CHAIN.getStartPos();
            if (this.firstBlockEntry == null) {
                this.clicks = 0;
            }
        } else {
            this.clicks = 0;
            return true;
        }
        return false;
    }

    @Override
    public void findCoordinates(BlockSet blocks) {
        if (this.clicks == 0) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (this.firstBlockEntry == null || this.firstBlockEntry.blockPos == null) {
            return;
        }
        BlockPos firstPos = this.firstBlockEntry.blockPos;
        BlockPos secondPos = this.findSecondPos((Player)player, this.firstBlockEntry.blockPos, true);
        if (secondPos == null) {
            return;
        }
        int axisLimit = AttachmentHandler.getMaxBlocksPerAxis((Player)player, false);
        int x1 = firstPos.getX();
        int x2 = secondPos.getX();
        int y1 = firstPos.getY();
        int y2 = secondPos.getY();
        int z1 = firstPos.getZ();
        int z2 = secondPos.getZ();
        if (x2 - x1 >= axisLimit) {
            x2 = x1 + axisLimit - 1;
        }
        if (x1 - x2 >= axisLimit) {
            x2 = x1 - axisLimit + 1;
        }
        if (y2 - y1 >= axisLimit) {
            y2 = y1 + axisLimit - 1;
        }
        if (y1 - y2 >= axisLimit) {
            y2 = y1 - axisLimit + 1;
        }
        if (z2 - z1 >= axisLimit) {
            z2 = z1 + axisLimit - 1;
        }
        if (z1 - z2 >= axisLimit) {
            z2 = z1 - axisLimit + 1;
        }
        blocks.clear();
        for (BlockPos pos : this.getAllBlocks((Player)player, x1, y1, z1, x2, y2, z2)) {
            if (blocks.containsKey(pos)) continue;
            blocks.add(new BlockEntry(pos));
        }
        blocks.firstPos = firstPos;
        blocks.lastPos = secondPos;
    }

    protected abstract BlockPos findSecondPos(Player var1, BlockPos var2, boolean var3);

    protected abstract List<BlockPos> getAllBlocks(Player var1, int var2, int var3, int var4, int var5, int var6, int var7);
}

