/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmode.buildmodes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import sophisticated.building.buildmode.ModeOptions;
import sophisticated.building.buildmode.TwoClicksBuildMode;
import sophisticated.building.buildmode.buildmodes.Floor;

public class Circle
extends TwoClicksBuildMode {
    public static List<BlockPos> getCircleBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        float centerX = x1;
        float centerZ = z1;
        if (ModeOptions.getCircleStart() == ModeOptions.ActionEnum.CIRCLE_START_CORNER) {
            centerX = (float)x1 + (float)(x2 - x1) / 2.0f;
            centerZ = (float)z1 + (float)(z2 - z1) / 2.0f;
        } else {
            x1 = (int)(centerX - ((float)x2 - centerX));
            z1 = (int)(centerZ - ((float)z2 - centerZ));
        }
        float radiusX = Mth.abs((float)((float)x2 - centerX));
        float radiusZ = Mth.abs((float)((float)z2 - centerZ));
        if (ModeOptions.getFill() == ModeOptions.ActionEnum.FULL) {
            Circle.addCircleBlocks(list, x1, y1, z1, x2, y2, z2, centerX, centerZ, radiusX, radiusZ);
        } else {
            Circle.addHollowCircleBlocks(list, x1, y1, z1, x2, y2, z2, centerX, centerZ, radiusX, radiusZ);
        }
        return list;
    }

    public static void addCircleBlocks(List<BlockPos> list, int x1, int y1, int z1, int x2, int y2, int z2, float centerX, float centerZ, float radiusX, float radiusZ) {
        int l = x1;
        while (x1 < x2 ? l <= x2 : l >= x2) {
            int n = z1;
            while (z1 < z2 ? n <= z2 : n >= z2) {
                float radius;
                float distance = Circle.distance(l, n, centerX, centerZ);
                if (distance < (radius = Circle.calculateEllipseRadius(centerX, centerZ, radiusX, radiusZ, l, n)) + 0.4f) {
                    list.add(new BlockPos(l, y1, n));
                }
                n += z1 < z2 ? 1 : -1;
            }
            l += x1 < x2 ? 1 : -1;
        }
    }

    public static void addHollowCircleBlocks(List<BlockPos> list, int x1, int y1, int z1, int x2, int y2, int z2, float centerX, float centerZ, float radiusX, float radiusZ) {
        int l = x1;
        while (x1 < x2 ? l <= x2 : l >= x2) {
            int n = z1;
            while (z1 < z2 ? n <= z2 : n >= z2) {
                float radius;
                float distance = Circle.distance(l, n, centerX, centerZ);
                if (distance < (radius = Circle.calculateEllipseRadius(centerX, centerZ, radiusX, radiusZ, l, n)) + 0.4f && distance > radius - 0.6f) {
                    list.add(new BlockPos(l, y1, n));
                }
                n += z1 < z2 ? 1 : -1;
            }
            l += x1 < x2 ? 1 : -1;
        }
    }

    private static float distance(float x1, float z1, float x2, float z2) {
        return Mth.sqrt((float)((x2 - x1) * (x2 - x1) + (z2 - z1) * (z2 - z1)));
    }

    public static float calculateEllipseRadius(float centerX, float centerZ, float radiusX, float radiusZ, int x, int z) {
        float theta = (float)Mth.atan2((double)((float)z - centerZ), (double)((float)x - centerX));
        float part1 = radiusX * radiusX * Mth.sin((float)theta) * Mth.sin((float)theta);
        float part2 = radiusZ * radiusZ * Mth.cos((float)theta) * Mth.cos((float)theta);
        return radiusX * radiusZ / Mth.sqrt((float)(part1 + part2));
    }

    @Override
    protected BlockPos findSecondPos(Player player, BlockPos firstPos, boolean skipRaytrace) {
        return Floor.findFloor(player, firstPos, skipRaytrace);
    }

    @Override
    protected List<BlockPos> getAllBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Circle.getCircleBlocks(player, x1, y1, z1, x2, y2, z2);
    }
}

