/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmode.buildmodes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import sophisticated.building.buildmode.ModeOptions;
import sophisticated.building.buildmode.ThreeClicksBuildMode;
import sophisticated.building.buildmode.buildmodes.Circle;
import sophisticated.building.buildmode.buildmodes.Floor;

public class Cone
extends ThreeClicksBuildMode {
    public static List<BlockPos> getConeBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int z3) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        float centerX = x1;
        float centerZ = z1;
        if (ModeOptions.getCircleStart() == ModeOptions.ActionEnum.CIRCLE_START_CORNER) {
            centerX = (float)x1 + (float)(x2 - x1) / 2.0f;
            centerZ = (float)z1 + (float)(z2 - z1) / 2.0f;
        } else {
            x1 = (int)(centerX - ((float)x2 - centerX));
            z1 = (int)(centerZ - ((float)z2 - centerZ));
        }
        float baseRadiusX = Mth.abs((float)((float)x2 - centerX));
        float baseRadiusZ = Mth.abs((float)((float)z2 - centerZ));
        int baseY = y1;
        int apexY = y3;
        int heightDir = apexY > baseY ? 1 : -1;
        int totalHeight = Math.abs(apexY - baseY) + 1;
        boolean hollow = ModeOptions.getFill() == ModeOptions.ActionEnum.HOLLOW;
        for (int layer = 0; layer < totalHeight; ++layer) {
            int currentY = baseY + layer * heightDir;
            float layerRatio = totalHeight > 1 ? (float)layer / (float)(totalHeight - 1) : 0.0f;
            float layerRadiusX = baseRadiusX * (1.0f - layerRatio);
            float layerRadiusZ = baseRadiusZ * (1.0f - layerRatio);
            if (layerRadiusX < 0.5f && layerRadiusZ < 0.5f) {
                list.add(new BlockPos((int)centerX, currentY, (int)centerZ));
                continue;
            }
            int layerMinX = (int)Math.floor(centerX - layerRadiusX);
            int layerMaxX = (int)Math.ceil(centerX + layerRadiusX);
            int layerMinZ = (int)Math.floor(centerZ - layerRadiusZ);
            int layerMaxZ = (int)Math.ceil(centerZ + layerRadiusZ);
            for (int x = layerMinX; x <= layerMaxX; ++x) {
                for (int z = layerMinZ; z <= layerMaxZ; ++z) {
                    float distance = Cone.distance(x, z, centerX, centerZ);
                    float radius = Cone.calculateEllipseRadius(centerX, centerZ, layerRadiusX, layerRadiusZ, x, z);
                    if (hollow && layer > 0 && layer < totalHeight - 1) {
                        if (!(distance < radius + 0.4f) || !(distance > radius - 0.6f)) continue;
                        list.add(new BlockPos(x, currentY, z));
                        continue;
                    }
                    if (!(distance < radius + 0.4f)) continue;
                    list.add(new BlockPos(x, currentY, z));
                }
            }
        }
        return list;
    }

    private static float distance(float x1, float z1, float x2, float z2) {
        return Mth.sqrt((float)((x2 - x1) * (x2 - x1) + (z2 - z1) * (z2 - z1)));
    }

    private static float calculateEllipseRadius(float centerX, float centerZ, float radiusX, float radiusZ, int x, int z) {
        if (radiusX == 0.0f || radiusZ == 0.0f) {
            return 0.0f;
        }
        float theta = (float)Mth.atan2((double)((float)z - centerZ), (double)((float)x - centerX));
        float part1 = radiusX * radiusX * Mth.sin((float)theta) * Mth.sin((float)theta);
        float part2 = radiusZ * radiusZ * Mth.cos((float)theta) * Mth.cos((float)theta);
        return radiusX * radiusZ / Mth.sqrt((float)(part1 + part2));
    }

    @Override
    protected BlockPos findSecondPos(Player player, BlockPos firstPos, boolean skipRaytrace) {
        return Floor.findFloor(player, firstPos, skipRaytrace);
    }

    @Override
    protected BlockPos findThirdPos(Player player, BlockPos firstPos, BlockPos secondPos, boolean skipRaytrace) {
        return Cone.findHeight(player, secondPos, skipRaytrace);
    }

    @Override
    protected List<BlockPos> getIntermediateBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Circle.getCircleBlocks(player, x1, y1, z1, x2, y2, z2);
    }

    @Override
    protected List<BlockPos> getFinalBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int z3) {
        return Cone.getConeBlocks(player, x1, y1, z1, x2, y2, z2, x3, y3, z3);
    }
}

