/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmode.buildmodes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.buildmode.BuildModes;
import sophisticated.building.buildmode.ModeOptions;
import sophisticated.building.buildmode.TwoClicksBuildMode;
import sophisticated.building.buildmode.buildmodes.Line;

public class Floor
extends TwoClicksBuildMode {
    public static BlockPos findFloor(Player player, BlockPos firstPos, boolean skipRaytrace) {
        if (firstPos == null) {
            return null;
        }
        Vec3 look = BuildModes.getPlayerLookVec(player);
        Vec3 start = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>(3);
        Vec3 yBound = BuildModes.findYBound(firstPos.getY(), start, look);
        criteriaList.add(new Criteria(yBound, start));
        int reach = AttachmentHandler.getBuildModeReach(player);
        criteriaList.removeIf(criteria -> !criteria.isValid(start, look, reach, player, skipRaytrace));
        if (criteriaList.isEmpty()) {
            return null;
        }
        Criteria selected = (Criteria)criteriaList.get(0);
        return BlockPos.containing((Position)selected.planeBound);
    }

    public static List<BlockPos> getFloorBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        if (ModeOptions.getFill() == ModeOptions.ActionEnum.FULL) {
            Floor.addFloorBlocks(list, x1, x2, y1, z1, z2);
        } else {
            Floor.addHollowFloorBlocks(list, x1, x2, y1, z1, z2);
        }
        return list;
    }

    public static void addFloorBlocks(List<BlockPos> list, int x1, int x2, int y, int z1, int z2) {
        int l = x1;
        while (x1 < x2 ? l <= x2 : l >= x2) {
            int n = z1;
            while (z1 < z2 ? n <= z2 : n >= z2) {
                list.add(new BlockPos(l, y, n));
                n += z1 < z2 ? 1 : -1;
            }
            l += x1 < x2 ? 1 : -1;
        }
    }

    public static void addHollowFloorBlocks(List<BlockPos> list, int x1, int x2, int y, int z1, int z2) {
        Line.addXLineBlocks(list, x1, x2, y, z1);
        Line.addXLineBlocks(list, x1, x2, y, z2);
        Line.addZLineBlocks(list, z1, z2, x1, y);
        Line.addZLineBlocks(list, z1, z2, x2, y);
    }

    @Override
    protected BlockPos findSecondPos(Player player, BlockPos firstPos, boolean skipRaytrace) {
        return Floor.findFloor(player, firstPos, skipRaytrace);
    }

    @Override
    protected List<BlockPos> getAllBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Floor.getFloorBlocks(player, x1, y1, z1, x2, y2, z2);
    }

    static class Criteria {
        Vec3 planeBound;
        double distToPlayerSq;

        Criteria(Vec3 planeBound, Vec3 start) {
            this.planeBound = planeBound;
            this.distToPlayerSq = this.planeBound.subtract(start).lengthSqr();
        }

        public boolean isValid(Vec3 start, Vec3 look, int reach, Player player, boolean skipRaytrace) {
            return BuildModes.isCriteriaValid(start, look, reach, player, skipRaytrace, this.planeBound, this.planeBound, this.distToPlayerSq);
        }
    }
}

