/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmode.buildmodes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import sophisticated.building.buildmode.ModeOptions;
import sophisticated.building.buildmode.ThreeClicksBuildMode;
import sophisticated.building.buildmode.buildmodes.Floor;

public class Pyramid
extends ThreeClicksBuildMode {
    public static List<BlockPos> getPyramidBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int z3) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minZ = Math.min(z1, z2);
        int maxZ = Math.max(z1, z2);
        int apexY = y3;
        int baseY = y1;
        int heightDir = apexY > baseY ? 1 : -1;
        int totalHeight = Math.abs(apexY - baseY) + 1;
        int baseWidthX = maxX - minX;
        int baseWidthZ = maxZ - minZ;
        boolean hollow = ModeOptions.getFill() == ModeOptions.ActionEnum.HOLLOW;
        for (int layer = 0; layer < totalHeight; ++layer) {
            int x;
            int currentY = baseY + layer * heightDir;
            float shrinkRatioX = totalHeight > 1 ? (float)layer / (float)(totalHeight - 1) : 0.0f;
            float shrinkRatioZ = totalHeight > 1 ? (float)layer / (float)(totalHeight - 1) : 0.0f;
            int shrinkX = (int)(shrinkRatioX * (float)baseWidthX / 2.0f);
            int shrinkZ = (int)(shrinkRatioZ * (float)baseWidthZ / 2.0f);
            int layerMinX = minX + shrinkX;
            int layerMaxX = maxX - shrinkX;
            int layerMinZ = minZ + shrinkZ;
            int layerMaxZ = maxZ - shrinkZ;
            if (layerMinX > layerMaxX || layerMinZ > layerMaxZ) break;
            if (hollow && layer > 0 && layer < totalHeight - 1) {
                for (x = layerMinX; x <= layerMaxX; ++x) {
                    list.add(new BlockPos(x, currentY, layerMinZ));
                    if (layerMinZ == layerMaxZ) continue;
                    list.add(new BlockPos(x, currentY, layerMaxZ));
                }
                for (int z = layerMinZ + 1; z < layerMaxZ; ++z) {
                    list.add(new BlockPos(layerMinX, currentY, z));
                    if (layerMinX == layerMaxX) continue;
                    list.add(new BlockPos(layerMaxX, currentY, z));
                }
                continue;
            }
            for (x = layerMinX; x <= layerMaxX; ++x) {
                for (int z = layerMinZ; z <= layerMaxZ; ++z) {
                    list.add(new BlockPos(x, currentY, z));
                }
            }
        }
        return list;
    }

    @Override
    protected BlockPos findSecondPos(Player player, BlockPos firstPos, boolean skipRaytrace) {
        return Floor.findFloor(player, firstPos, skipRaytrace);
    }

    @Override
    protected BlockPos findThirdPos(Player player, BlockPos firstPos, BlockPos secondPos, boolean skipRaytrace) {
        return Pyramid.findHeight(player, secondPos, skipRaytrace);
    }

    @Override
    protected List<BlockPos> getIntermediateBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Floor.getFloorBlocks(player, x1, y1, z1, x2, y2, z2);
    }

    @Override
    protected List<BlockPos> getFinalBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int z3) {
        return Pyramid.getPyramidBlocks(player, x1, y1, z1, x2, y2, z2, x3, y3, z3);
    }
}

