/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmode.buildmodes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import sophisticated.building.buildmode.ModeOptions;
import sophisticated.building.buildmode.ThreeClicksBuildMode;
import sophisticated.building.buildmode.buildmodes.Circle;
import sophisticated.building.buildmode.buildmodes.Floor;

public class Sphere
extends ThreeClicksBuildMode {
    public static List<BlockPos> getSphereBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int z3) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        float centerX = x1;
        float centerY = y1;
        float centerZ = z1;
        if (ModeOptions.getCircleStart() == ModeOptions.ActionEnum.CIRCLE_START_CORNER) {
            centerX = (float)x1 + (float)(x2 - x1) / 2.0f;
            centerY = (float)y1 + (float)(y3 - y1) / 2.0f;
            centerZ = (float)z1 + (float)(z2 - z1) / 2.0f;
        } else {
            x1 = (int)(centerX - ((float)x2 - centerX));
            y1 = (int)(centerY - ((float)y3 - centerY));
            z1 = (int)(centerZ - ((float)z2 - centerZ));
        }
        float radiusX = Mth.abs((float)((float)x2 - centerX));
        float radiusY = Mth.abs((float)((float)y3 - centerY));
        float radiusZ = Mth.abs((float)((float)z2 - centerZ));
        if (ModeOptions.getFill() == ModeOptions.ActionEnum.FULL) {
            Sphere.addSphereBlocks(list, x1, y1, z1, x3, y3, z3, centerX, centerY, centerZ, radiusX, radiusY, radiusZ);
        } else {
            Sphere.addHollowSphereBlocks(list, x1, y1, z1, x3, y3, z3, centerX, centerY, centerZ, radiusX, radiusY, radiusZ);
        }
        return list;
    }

    public static void addSphereBlocks(List<BlockPos> list, int x1, int y1, int z1, int x2, int y2, int z2, float centerX, float centerY, float centerZ, float radiusX, float radiusY, float radiusZ) {
        int l = x1;
        while (x1 < x2 ? l <= x2 : l >= x2) {
            int n = z1;
            while (z1 < z2 ? n <= z2 : n >= z2) {
                int m = y1;
                while (y1 < y2 ? m <= y2 : m >= y2) {
                    float radius;
                    float distance = Sphere.distance(l, m, n, centerX, centerY, centerZ);
                    if (distance < (radius = Sphere.calculateSpheroidRadius(centerX, centerY, centerZ, radiusX, radiusY, radiusZ, l, m, n)) + 0.4f) {
                        list.add(new BlockPos(l, m, n));
                    }
                    m += y1 < y2 ? 1 : -1;
                }
                n += z1 < z2 ? 1 : -1;
            }
            l += x1 < x2 ? 1 : -1;
        }
    }

    public static void addHollowSphereBlocks(List<BlockPos> list, int x1, int y1, int z1, int x2, int y2, int z2, float centerX, float centerY, float centerZ, float radiusX, float radiusY, float radiusZ) {
        int l = x1;
        while (x1 < x2 ? l <= x2 : l >= x2) {
            int n = z1;
            while (z1 < z2 ? n <= z2 : n >= z2) {
                int m = y1;
                while (y1 < y2 ? m <= y2 : m >= y2) {
                    float radius;
                    float distance = Sphere.distance(l, m, n, centerX, centerY, centerZ);
                    if (distance < (radius = Sphere.calculateSpheroidRadius(centerX, centerY, centerZ, radiusX, radiusY, radiusZ, l, m, n)) + 0.4f && distance > radius - 0.6f) {
                        list.add(new BlockPos(l, m, n));
                    }
                    m += y1 < y2 ? 1 : -1;
                }
                n += z1 < z2 ? 1 : -1;
            }
            l += x1 < x2 ? 1 : -1;
        }
    }

    private static float distance(float x1, float y1, float z1, float x2, float y2, float z2) {
        return Mth.sqrt((float)((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1)));
    }

    public static float calculateSpheroidRadius(float centerX, float centerY, float centerZ, float radiusX, float radiusY, float radiusZ, int x, int y, int z) {
        float radiusXZ = Circle.calculateEllipseRadius(centerX, centerZ, radiusX, radiusZ, x, z);
        return Circle.calculateEllipseRadius(centerX, centerY, radiusXZ, radiusY, x, y);
    }

    @Override
    public BlockPos findSecondPos(Player player, BlockPos firstPos, boolean skipRaytrace) {
        return Floor.findFloor(player, firstPos, skipRaytrace);
    }

    @Override
    public BlockPos findThirdPos(Player player, BlockPos firstPos, BlockPos secondPos, boolean skipRaytrace) {
        return Sphere.findHeight(player, secondPos, skipRaytrace);
    }

    @Override
    public List<BlockPos> getIntermediateBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Circle.getCircleBlocks(player, x1, y1, z1, x2, y2, z2);
    }

    @Override
    public List<BlockPos> getFinalBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int z3) {
        return Sphere.getSphereBlocks(player, x1, y1, z1, x2, y2, z2, x3, y3, z3);
    }
}

