/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmodifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import sophisticated.building.buildmodifier.Array;
import sophisticated.building.buildmodifier.BaseModifier;
import sophisticated.building.buildmodifier.Mirror;
import sophisticated.building.buildmodifier.RadialMirror;
import sophisticated.building.network.message.ModifierSettingsPacket;
import sophisticated.building.utilities.BlockSet;

@OnlyIn(value=Dist.CLIENT)
public class BuildModifiers {
    private List<BaseModifier> modifierSettingsList = new ArrayList<BaseModifier>();

    public List<BaseModifier> getModifierSettingsList() {
        return Collections.unmodifiableList(this.modifierSettingsList);
    }

    public void addModifierSettings(BaseModifier modifierSettings) {
        this.modifierSettingsList.add(modifierSettings);
    }

    public void removeModifierSettings(BaseModifier modifierSettings) {
        this.modifierSettingsList.remove(modifierSettings);
    }

    public void removeModifierSettings(int index) {
        this.modifierSettingsList.remove(index);
    }

    public void moveUp(BaseModifier modifierSettings) {
        int index = this.modifierSettingsList.indexOf(modifierSettings);
        if (index == 0) {
            return;
        }
        Collections.swap(this.modifierSettingsList, index, index - 1);
    }

    public void moveDown(BaseModifier modifierSettings) {
        int index = this.modifierSettingsList.indexOf(modifierSettings);
        if (index == this.modifierSettingsList.size() - 1) {
            return;
        }
        Collections.swap(this.modifierSettingsList, index, index + 1);
    }

    public void setFirst(BaseModifier modifierSettings) {
        int index = this.modifierSettingsList.indexOf(modifierSettings);
        if (index == 0) {
            return;
        }
        this.modifierSettingsList.remove(index);
        this.modifierSettingsList.add(0, modifierSettings);
    }

    public void setLast(BaseModifier modifierSettings) {
        int index = this.modifierSettingsList.indexOf(modifierSettings);
        if (index == this.modifierSettingsList.size() - 1) {
            return;
        }
        this.modifierSettingsList.remove(index);
        this.modifierSettingsList.add(modifierSettings);
    }

    public void clearAllModifierSettings() {
        this.modifierSettingsList.clear();
    }

    public void findCoordinates(BlockSet blocks, Player player) {
        for (BaseModifier modifierSettings : this.modifierSettingsList) {
            modifierSettings.findCoordinates(blocks, player);
        }
    }

    public void onPowerLevelChanged(int powerLevel) {
        for (BaseModifier modifierSettings : this.modifierSettingsList) {
            modifierSettings.onPowerLevelChanged(powerLevel);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("modifierSettingsList", (Tag)NBTHelper.writeCompoundList(this.modifierSettingsList, BaseModifier::serializeNBT));
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        ListTag listTag = compoundTag.getList("modifierSettingsList", 10);
        this.modifierSettingsList = NBTHelper.readCompoundList((ListTag)listTag, tag -> {
            BaseModifier modifier = this.createModifier(tag.getString("type"));
            modifier.deserializeNBT((CompoundTag)tag);
            return modifier;
        });
    }

    public void save() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ModifierSettingsPacket(this.serializeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private BaseModifier createModifier(String type) {
        switch (type) {
            case "Mirror": {
                return new Mirror();
            }
            case "Array": {
                return new Array();
            }
            case "RadialMirror": {
                return new RadialMirror();
            }
        }
        throw new IllegalArgumentException("Unknown modifier type: " + type);
    }
}

