/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.buildmodifier;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.buildmodifier.BaseModifier;
import sophisticated.building.utilities.BlockEntry;
import sophisticated.building.utilities.BlockSet;

public class Mirror
extends BaseModifier {
    public Vec3 position = new Vec3(0.5, 64.5, 0.5);
    public boolean mirrorX = true;
    public boolean mirrorY = false;
    public boolean mirrorZ = false;
    public int radius = 10;
    public boolean drawLines = true;
    public boolean drawPlanes = true;

    public Mirror() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            this.position = Vec3.atLowerCornerOf((Vec3i)Minecraft.getInstance().player.blockPosition());
        }
    }

    @Override
    public void findCoordinates(BlockSet blocks, Player player) {
        if (!this.enabled || !this.mirrorX && !this.mirrorY && !this.mirrorZ) {
            return;
        }
        BlockSet originalBlocks = new BlockSet(blocks);
        for (BlockEntry blockEntry : originalBlocks) {
            if (!this.isWithinRange(blockEntry.blockPos)) continue;
            if (this.mirrorX) {
                this.performMirrorX(blocks, blockEntry);
            }
            if (this.mirrorY) {
                this.performMirrorY(blocks, blockEntry);
            }
            if (!this.mirrorZ) continue;
            this.performMirrorZ(blocks, blockEntry);
        }
    }

    @Override
    public void onPowerLevelChanged(int powerLevel) {
        this.radius = AttachmentHandler.getMaxMirrorRadius((Player)Minecraft.getInstance().player, false);
    }

    private void performMirrorX(BlockSet blocks, BlockEntry blockEntry) {
        double x = this.position.x + (this.position.x - (double)blockEntry.blockPos.getX() - 0.5);
        BlockPos newBlockPos = BlockPos.containing((double)x, (double)blockEntry.blockPos.getY(), (double)blockEntry.blockPos.getZ());
        if (blocks.containsKey(newBlockPos)) {
            return;
        }
        BlockEntry newBlockEntry = new BlockEntry(newBlockPos);
        newBlockEntry.copyRotationSettingsFrom(blockEntry);
        newBlockEntry.mirrorX = !newBlockEntry.mirrorX;
        blocks.add(newBlockEntry);
        if (this.mirrorY) {
            this.performMirrorY(blocks, newBlockEntry);
        }
        if (this.mirrorZ) {
            this.performMirrorZ(blocks, newBlockEntry);
        }
    }

    private void performMirrorY(BlockSet blocks, BlockEntry blockEntry) {
        double y = this.position.y + (this.position.y - (double)blockEntry.blockPos.getY() - 0.5);
        BlockPos newBlockPos = BlockPos.containing((double)blockEntry.blockPos.getX(), (double)y, (double)blockEntry.blockPos.getZ());
        if (blocks.containsKey(newBlockPos)) {
            return;
        }
        BlockEntry newBlockEntry = new BlockEntry(newBlockPos);
        newBlockEntry.copyRotationSettingsFrom(blockEntry);
        newBlockEntry.mirrorY = !newBlockEntry.mirrorY;
        blocks.add(newBlockEntry);
        if (this.mirrorZ) {
            this.performMirrorZ(blocks, newBlockEntry);
        }
    }

    private void performMirrorZ(BlockSet blocks, BlockEntry blockEntry) {
        double z = this.position.z + (this.position.z - (double)blockEntry.blockPos.getZ() - 0.5);
        BlockPos newBlockPos = BlockPos.containing((double)blockEntry.blockPos.getX(), (double)blockEntry.blockPos.getY(), (double)z);
        if (blocks.containsKey(newBlockPos)) {
            return;
        }
        BlockEntry newBlockEntry = new BlockEntry(newBlockPos);
        newBlockEntry.copyRotationSettingsFrom(blockEntry);
        newBlockEntry.mirrorZ = !newBlockEntry.mirrorZ;
        blocks.add(newBlockEntry);
    }

    public boolean isWithinRange(BlockPos blockPos) {
        return !((double)blockPos.getX() + 0.5 < this.position.x - (double)this.radius || (double)blockPos.getX() + 0.5 > this.position.x + (double)this.radius || (double)blockPos.getY() + 0.5 < this.position.y - (double)this.radius || (double)blockPos.getY() + 0.5 > this.position.y + (double)this.radius || (double)blockPos.getZ() + 0.5 < this.position.z - (double)this.radius || (double)blockPos.getZ() + 0.5 > this.position.z + (double)this.radius);
    }

    public int getReach() {
        return this.radius * 2;
    }

    public void toggleMirrorAxis(int index) {
        switch (index) {
            case 0: {
                this.mirrorX = !this.mirrorX;
                break;
            }
            case 1: {
                this.mirrorY = !this.mirrorY;
                break;
            }
            case 2: {
                this.mirrorZ = !this.mirrorZ;
            }
        }
    }

    public boolean getMirrorAxis(int index) {
        switch (index) {
            case 0: {
                return this.mirrorX;
            }
            case 1: {
                return this.mirrorY;
            }
            case 2: {
                return this.mirrorZ;
            }
        }
        return false;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.putDouble("positionX", this.position.x);
        compound.putDouble("positionY", this.position.y);
        compound.putDouble("positionZ", this.position.z);
        compound.putBoolean("mirrorX", this.mirrorX);
        compound.putBoolean("mirrorY", this.mirrorY);
        compound.putBoolean("mirrorZ", this.mirrorZ);
        compound.putInt("radius", this.radius);
        compound.putBoolean("drawLines", this.drawLines);
        compound.putBoolean("drawPlanes", this.drawPlanes);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.position = new Vec3(compound.getDouble("positionX"), compound.getDouble("positionY"), compound.getDouble("positionZ"));
        this.mirrorX = compound.getBoolean("mirrorX");
        this.mirrorY = compound.getBoolean("mirrorY");
        this.mirrorZ = compound.getBoolean("mirrorZ");
        this.radius = compound.getInt("radius");
        this.drawLines = compound.getBoolean("drawLines");
        this.drawPlanes = compound.getBoolean("drawPlanes");
    }
}

