/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.client.gui;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.buildmode.BuildModeEnum;
import sophisticated.building.utilities.BlockEntry;
import sophisticated.building.utilities.BlockSet;

public class MaterialCostOverlay
implements LayeredDraw.Layer {
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (SophisticatedBuildingClient.BUILD_MODES.getBuildMode() == BuildModeEnum.DISABLED) {
            return;
        }
        BlockSet blocks = SophisticatedBuildingClient.BUILDER_CHAIN.getBlocks();
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        HashMap<Item, Integer> costs = new HashMap<Item, Integer>();
        int totalBlocks = 0;
        for (BlockEntry entry : blocks) {
            Item item;
            if (entry.newBlockState == null || entry.newBlockState.isAir() || (item = entry.newBlockState.getBlock().asItem()) == null) continue;
            costs.merge(item, 1, Integer::sum);
            ++totalBlocks;
        }
        if (costs.isEmpty()) {
            return;
        }
        int x = 10;
        int y = mc.getWindow().getGuiScaledHeight() / 2 - costs.size() * 20 / 2;
        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"sophisticatedbuilding.overlay.total", (Object[])new Object[]{totalBlocks}), x, y - 15, 0xFFFFFF);
        for (Map.Entry entry : costs.entrySet()) {
            ItemStack stack = new ItemStack((ItemLike)entry.getKey());
            int count = (Integer)entry.getValue();
            guiGraphics.renderItem(stack, x, y);
            guiGraphics.renderItemDecorations(mc.font, stack, x, y);
            guiGraphics.drawString(mc.font, count + "x " + stack.getHoverName().getString(), x + 20, y + 4, 0xFFFFFF);
            y += 20;
        }
    }
}

