/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.compatibility;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.items.IItemHandler;
import sophisticated.building.create.foundation.item.ItemHelper;
import sophisticated.building.item.AbstractRandomizerBagItem;

public class CompatHelper {
    private static Boolean sophisticatedBackpacksLoaded = null;

    public static void setup() {
    }

    public static boolean isSophisticatedBackpacksLoaded() {
        if (sophisticatedBackpacksLoaded == null) {
            try {
                ModList modList = ModList.get();
                sophisticatedBackpacksLoaded = modList != null ? Boolean.valueOf(modList.isLoaded("sophisticatedbackpacks")) : Boolean.valueOf(FMLLoader.getLoadingModList().getModFileById("sophisticatedbackpacks") != null);
            }
            catch (Exception e) {
                sophisticatedBackpacksLoaded = false;
            }
        }
        return sophisticatedBackpacksLoaded;
    }

    public static boolean isItemBlockProxy(ItemStack stack) {
        return CompatHelper.isItemBlockProxy(stack, true);
    }

    public static boolean isItemBlockProxy(ItemStack stack, boolean seeBlockItemsAsProxies) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            return seeBlockItemsAsProxies;
        }
        return item instanceof AbstractRandomizerBagItem;
    }

    public static ItemStack getItemBlockForPosition(ItemStack proxy, BlockPos pos, @Nullable Player player) {
        Item proxyItem = proxy.getItem();
        if (proxyItem instanceof BlockItem) {
            return proxy;
        }
        if (proxyItem instanceof AbstractRandomizerBagItem) {
            AbstractRandomizerBagItem randomizerBagItem = (AbstractRandomizerBagItem)proxyItem;
            IItemHandler bagInventory = randomizerBagItem.getBagInventory(proxy);
            if (bagInventory == null) {
                return ItemStack.EMPTY;
            }
            return randomizerBagItem.pickRandomStackCachedForPosition(bagInventory, pos, player);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getItemBlockFromStackFresh(ItemStack proxy, @Nullable Player player) {
        Item proxyItem = proxy.getItem();
        if (proxyItem instanceof BlockItem) {
            return proxy;
        }
        if (proxyItem instanceof AbstractRandomizerBagItem) {
            AbstractRandomizerBagItem randomizerBagItem = (AbstractRandomizerBagItem)proxyItem;
            IItemHandler bagInventory = randomizerBagItem.getBagInventory(proxy);
            if (bagInventory == null) {
                return ItemStack.EMPTY;
            }
            return randomizerBagItem.pickRandomTemplateFresh(bagInventory, player);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getItemBlockFromStack(ItemStack proxy) {
        return CompatHelper.getItemBlockFromStackFresh(proxy, null);
    }

    public static ItemStack getItemBlockByState(ItemStack stack, BlockState state) {
        if (state == null) {
            return ItemStack.EMPTY;
        }
        Item blockItem = Item.byBlock((Block)state.getBlock());
        if (stack.getItem() instanceof BlockItem) {
            return stack;
        }
        if (stack.getItem() instanceof AbstractRandomizerBagItem) {
            AbstractRandomizerBagItem randomizerBagItem = (AbstractRandomizerBagItem)stack.getItem();
            IItemHandler bagInventory = randomizerBagItem.getBagInventory(stack);
            return randomizerBagItem.findStack(bagInventory, blockItem);
        }
        return ItemStack.EMPTY;
    }

    public static boolean containsBlock(ItemStack stack, Block block) {
        if (stack == null || stack.isEmpty() || !CompatHelper.isItemBlockProxy(stack)) {
            return block == null || block == Blocks.AIR;
        }
        if (stack.getItem() instanceof BlockItem) {
            return ((BlockItem)stack.getItem()).getBlock() == block;
        }
        Item item = stack.getItem();
        if (item instanceof AbstractRandomizerBagItem) {
            AbstractRandomizerBagItem randomizerBagItem = (AbstractRandomizerBagItem)item;
            IItemHandler bagInventory = randomizerBagItem.getBagInventory(stack);
            ItemStack firstMatch = ItemHelper.findFirstMatch(bagInventory, s -> s.getItem() instanceof BlockItem);
            return firstMatch != null && !firstMatch.isEmpty();
        }
        return false;
    }
}

