/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.create.foundation.item;

import com.google.common.base.Strings;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.lang.ClientFontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sophisticated.building.create.foundation.item.ItemDescription;
import sophisticated.building.create.foundation.utility.Components;
import sophisticated.building.create.foundation.utility.Lang;

public class TooltipHelper {
    public static final int maxWidthPerLine = 200;
    public static final Map<String, ItemDescription> cachedTooltips = new HashMap<String, ItemDescription>();
    private static boolean gogglesMode;
    private static final Map<Item, Supplier<String>> tooltipReferrals;

    public static MutableComponent holdShift(ItemDescription.Palette color, boolean highlighted) {
        return Lang.translateDirect("tooltip.holdForDescription", Lang.translateDirect("tooltip.keyShift", new Object[0]).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY);
    }

    public static void addHint(List<Component> tooltip, String hintKey, Object ... messageParams) {
        MutableComponent spacing = Components.literal("");
        tooltip.add((Component)spacing.plainCopy().append((Component)Lang.translateDirect(hintKey + ".title", new Object[0])).withStyle(ChatFormatting.GOLD));
        MutableComponent hint = Lang.translateDirect(hintKey, new Object[0]);
        List<Component> cutComponent = TooltipHelper.cutTextComponent((Component)hint, ChatFormatting.GRAY, ChatFormatting.WHITE);
        for (Component component : cutComponent) {
            tooltip.add((Component)spacing.plainCopy().append(component));
        }
    }

    public static void referTo(ItemLike item, Supplier<? extends ItemLike> itemWithTooltip) {
        tooltipReferrals.put(item.asItem(), () -> ((ItemLike)itemWithTooltip.get()).asItem().getDescriptionId());
    }

    public static void referTo(ItemLike item, String string) {
        tooltipReferrals.put(item.asItem(), () -> string);
    }

    @Deprecated
    public static List<String> cutString(Component s, ChatFormatting defaultColor, ChatFormatting highlightColor) {
        return TooltipHelper.cutString(s.getString(), defaultColor, highlightColor, 0);
    }

    @Deprecated
    public static List<String> cutString(String s, ChatFormatting defaultColor, ChatFormatting highlightColor, int indent) {
        String markedUp = s.replaceAll("_([^_]+)_", String.valueOf(highlightColor) + "$1" + String.valueOf(defaultColor));
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(Minecraft.getInstance().getLocale());
        iterator.setText(markedUp);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = markedUp.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        Font font = Minecraft.getInstance().font;
        List lines = ClientFontHelper.cutString((Font)font, (String)markedUp, (int)200);
        String lineStart = Strings.repeat((String)" ", (int)indent);
        ArrayList<String> formattedLines = new ArrayList<String>(lines.size());
        String format = defaultColor.toString();
        for (String line : lines) {
            String formattedLine = format + lineStart + line;
            formattedLines.add(formattedLine);
        }
        return formattedLines;
    }

    public static List<Component> cutStringTextComponent(String c, ChatFormatting defaultColor, ChatFormatting highlightColor) {
        return TooltipHelper.cutTextComponent((Component)Components.literal(c), defaultColor, highlightColor, 0);
    }

    public static List<Component> cutTextComponent(Component c, ChatFormatting defaultColor, ChatFormatting highlightColor) {
        return TooltipHelper.cutTextComponent(c, defaultColor, highlightColor, 0);
    }

    public static List<Component> cutStringTextComponent(String c, ChatFormatting defaultColor, ChatFormatting highlightColor, int indent) {
        return TooltipHelper.cutTextComponent((Component)Components.literal(c), defaultColor, highlightColor, indent);
    }

    public static List<Component> cutTextComponent(Component c, ChatFormatting defaultColor, ChatFormatting highlightColor, int indent) {
        String s;
        String markedUp = s = c.getString();
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(Minecraft.getInstance().getLocale());
        iterator.setText(markedUp);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = markedUp.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        Font font = Minecraft.getInstance().font;
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.width(word.replaceAll("_", ""));
            if (width + newWidth > 200) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        MutableComponent lineStart = Components.literal(Strings.repeat((String)" ", (int)indent));
        lineStart.withStyle(defaultColor);
        ArrayList<Component> formattedLines = new ArrayList<Component>(lines.size());
        Couple f = Couple.create((Object)highlightColor, (Object)defaultColor);
        boolean currentlyHighlighted = false;
        for (String string : lines) {
            String[] split;
            MutableComponent currentComponent = lineStart.plainCopy();
            for (String part : split = string.split("_")) {
                currentComponent.append((Component)Components.literal(part).withStyle((ChatFormatting)f.get(currentlyHighlighted)));
                currentlyHighlighted = !currentlyHighlighted;
            }
            formattedLines.add((Component)currentComponent);
            currentlyHighlighted = !currentlyHighlighted;
        }
        return formattedLines;
    }

    private static boolean findTooltip(ItemStack stack) {
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (I18n.exists((String)key)) {
            cachedTooltips.put(key, TooltipHelper.buildToolTip(key, stack));
            return true;
        }
        cachedTooltips.put(key, ItemDescription.MISSING);
        return false;
    }

    private static ItemDescription buildToolTip(String translationKey, ItemStack stack) {
        int i;
        ItemDescription tooltip = new ItemDescription(ItemDescription.Palette.Blue);
        String summaryKey = translationKey + ".summary";
        if (I18n.exists((String)summaryKey)) {
            tooltip = tooltip.withSummary((Component)Components.literal(I18n.get((String)summaryKey, (Object[])new Object[0])));
        }
        for (i = 1; i < 100; ++i) {
            String conditionKey = translationKey + ".condition" + i;
            String behaviourKey = translationKey + ".behaviour" + i;
            if (!I18n.exists((String)conditionKey)) break;
            if (i == 1) {
                tooltip.getLinesOnShift().add(Components.immutableEmpty());
            }
            tooltip.withBehaviour(I18n.get((String)conditionKey, (Object[])new Object[0]), I18n.get((String)behaviourKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String controlKey = translationKey + ".control" + i;
            String actionKey = translationKey + ".action" + i;
            if (!I18n.exists((String)controlKey)) break;
            tooltip.withControl(I18n.get((String)controlKey, (Object[])new Object[0]), I18n.get((String)actionKey, (Object[])new Object[0]));
        }
        return tooltip.createTabs();
    }

    public static String getTooltipTranslationKey(ItemStack stack) {
        Item item = stack.getItem();
        if (tooltipReferrals.containsKey(item)) {
            return tooltipReferrals.get(item).get() + ".tooltip";
        }
        return item.getDescriptionId(stack) + ".tooltip";
    }

    static {
        tooltipReferrals = new HashMap<Item, Supplier<String>>();
    }
}

