/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.create.foundation.utility;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.SpecialPlantable;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import sophisticated.building.create.foundation.utility.IPartialSafeNBT;

public class BlockHelper {
    private static final List<IntegerProperty> COUNT_STATES = List.of(BlockStateProperties.EGGS, BlockStateProperties.PICKLES, BlockStateProperties.CANDLES);
    private static final List<Block> VINELIKE_BLOCKS = List.of(Blocks.VINE, Blocks.GLOW_LICHEN);
    private static final List<BooleanProperty> VINELIKE_STATES = List.of(BlockStateProperties.UP, BlockStateProperties.NORTH, BlockStateProperties.EAST, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.DOWN);

    public static BlockState setZeroAge(BlockState blockState) {
        if (blockState.hasProperty((Property)BlockStateProperties.AGE_1)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_1, (Comparable)Integer.valueOf(0));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AGE_2)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(0));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AGE_3)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AGE_5)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_5, (Comparable)Integer.valueOf(0));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AGE_7)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(0));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AGE_15)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(0));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AGE_25)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_25, (Comparable)Integer.valueOf(0));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.LEVEL_HONEY)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.LEVEL_HONEY, (Comparable)Integer.valueOf(0));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HATCH)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.HATCH, (Comparable)Integer.valueOf(0));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.STAGE)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.STAGE, (Comparable)Integer.valueOf(0));
        }
        if (blockState.is(BlockTags.CAULDRONS)) {
            return Blocks.CAULDRON.defaultBlockState();
        }
        if (blockState.hasProperty((Property)BlockStateProperties.LEVEL_COMPOSTER)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(0));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.EXTENDED)) {
            return (BlockState)blockState.setValue((Property)BlockStateProperties.EXTENDED, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    public static ItemStack getRequiredItem(BlockState state) {
        ItemStack itemStack = new ItemStack((ItemLike)state.getBlock());
        Item item = itemStack.getItem();
        if (item == Items.FARMLAND || item == Items.DIRT_PATH) {
            itemStack = new ItemStack((ItemLike)Items.DIRT);
        }
        return itemStack;
    }

    public static void destroyBlock(Level world, BlockPos pos, float effectChance) {
        BlockHelper.destroyBlock(world, pos, effectChance, stack -> Block.popResource((Level)world, (BlockPos)pos, (ItemStack)stack));
    }

    public static void destroyBlock(Level world, BlockPos pos, float effectChance, Consumer<ItemStack> droppedItemCallback) {
        BlockHelper.destroyBlockAs(world, pos, null, ItemStack.EMPTY, effectChance, droppedItemCallback);
    }

    public static boolean destroyBlockAs(Level world, BlockPos pos, @Nullable Player player, ItemStack usedTool, float effectChance, Consumer<ItemStack> droppedItemCallback) {
        BlockEntity blockEntity;
        FluidState fluidState = world.getFluidState(pos);
        BlockState state = world.getBlockState(pos);
        if (world.random.nextFloat() < effectChance) {
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        BlockEntity blockEntity2 = blockEntity = state.hasBlockEntity() ? world.getBlockEntity(pos) : null;
        if (player != null) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return false;
            }
            usedTool.mineBlock(world, state, pos, player);
            player.awardStat(Stats.BLOCK_MINED.get((Object)state.getBlock()));
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (!(!world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) || world.restoringBlockSnapshots || player != null && player.isCreative())) {
                List drops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)usedTool);
                if (player != null) {
                    BlockDropsEvent event = new BlockDropsEvent(serverLevel, pos, state, blockEntity, List.of(), (Entity)player, usedTool);
                    NeoForge.EVENT_BUS.post((Event)event);
                    if (!event.isCanceled() && event.getDroppedExperience() > 0) {
                        state.getBlock().popExperience(serverLevel, pos, event.getDroppedExperience());
                    }
                }
                for (ItemStack itemStack : drops) {
                    droppedItemCallback.accept(itemStack);
                }
                Registry enchantmentRegistry = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                if (state.getBlock() instanceof IceBlock && usedTool.getEnchantmentLevel((Holder)enchantmentRegistry.getHolderOrThrow(Enchantments.SILK_TOUCH)) == 0) {
                    if (world.dimensionType().ultraWarm()) {
                        return false;
                    }
                    BlockState blockstate = world.getBlockState(pos.below());
                    if (blockstate.blocksMotion() || blockstate.liquid()) {
                        world.setBlockAndUpdate(pos, Blocks.WATER.defaultBlockState());
                    }
                    return false;
                }
                state.spawnAfterBreak((ServerLevel)world, pos, ItemStack.EMPTY, true);
            }
        }
        world.setBlockAndUpdate(pos, fluidState.createLegacyBlock());
        return true;
    }

    public static boolean isSolidWall(BlockGetter reader, BlockPos fromPos, Direction toDirection) {
        return BlockHelper.hasBlockSolidSide(reader.getBlockState(fromPos.relative(toDirection)), reader, fromPos.relative(toDirection), toDirection.getOpposite());
    }

    public static boolean noCollisionInSpace(BlockGetter reader, BlockPos pos) {
        return reader.getBlockState(pos).getCollisionShape(reader, pos).isEmpty();
    }

    private static void placeRailWithoutUpdate(Level world, BlockState state, BlockPos target) {
        int idx;
        LevelChunk chunk = world.getChunkAt(target);
        LevelChunkSection chunksection = chunk.getSection(idx = chunk.getSectionIndex(target.getY()));
        if (chunksection == null) {
            chunk.getSections()[idx] = chunksection = new LevelChunkSection(world.registryAccess().registryOrThrow(Registries.BIOME));
        }
        BlockState old = chunksection.setBlockState(SectionPos.sectionRelative((int)target.getX()), SectionPos.sectionRelative((int)target.getY()), SectionPos.sectionRelative((int)target.getZ()), state);
        chunk.setUnsaved(true);
        world.markAndNotifyBlock(target, chunk, old, state, 82, 512);
        world.setBlock(target, state, 82);
        world.neighborChanged(target, world.getBlockState(target.below()).getBlock(), target.below());
    }

    public static CompoundTag prepareBlockEntityData(BlockState blockState, BlockEntity blockEntity) {
        CompoundTag data = null;
        if (blockEntity == null) {
            return null;
        }
        RegistryAccess access = blockEntity.getLevel().registryAccess();
        if (blockEntity instanceof IPartialSafeNBT) {
            IPartialSafeNBT safeNbtBE = (IPartialSafeNBT)blockEntity;
            data = new CompoundTag();
            safeNbtBE.writeSafe(data, access);
            data = NBTProcessors.process((BlockState)blockState, (BlockEntity)blockEntity, (CompoundTag)data, (boolean)true);
        }
        return data;
    }

    public static void placeSchematicBlock(Level world, BlockState state, BlockPos target, ItemStack stack, @Nullable CompoundTag data) {
        BlockEntity blockEntity;
        Block block;
        BlockEntity existingBlockEntity = world.getBlockEntity(target);
        boolean alreadyPlaced = false;
        if (state.hasProperty((Property)BlockStateProperties.EXTENDED)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.EXTENDED, (Comparable)Boolean.FALSE);
        }
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        if (state.getBlock() == Blocks.COMPOSTER) {
            state = Blocks.COMPOSTER.defaultBlockState();
        } else if (state.getBlock() != Blocks.SEA_PICKLE && (block = state.getBlock()) instanceof SpecialPlantable) {
            SpecialPlantable specialPlantable = (SpecialPlantable)block;
            alreadyPlaced = true;
            if (specialPlantable.canPlacePlantAtPosition(stack, (LevelReader)world, target, null)) {
                specialPlantable.spawnPlantAtPosition(stack, (LevelAccessor)world, target, null);
            }
        } else if (state.is(BlockTags.CAULDRONS)) {
            state = Blocks.CAULDRON.defaultBlockState();
        }
        if (world.dimensionType().ultraWarm() && state.getFluidState().is(FluidTags.WATER)) {
            int i = target.getX();
            int j = target.getY();
            int k = target.getZ();
            world.playSound(null, target, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            Block.dropResources((BlockState)state, (Level)world, (BlockPos)target);
            return;
        }
        if (!alreadyPlaced) {
            if (state.getBlock() instanceof BaseRailBlock) {
                BlockHelper.placeRailWithoutUpdate(world, state, target);
            } else {
                world.setBlock(target, state, 18);
            }
        }
        if (data != null && (blockEntity = world.getBlockEntity(target)) != null) {
            data.putInt("x", target.getX());
            data.putInt("y", target.getY());
            data.putInt("z", target.getZ());
            blockEntity.loadWithComponents(data, (HolderLookup.Provider)world.registryAccess());
        }
        try {
            state.getBlock().setPlacedBy(world, target, state, null, stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static double getBounceMultiplier(Block block) {
        if (block instanceof SlimeBlock) {
            return 0.8;
        }
        if (block instanceof BedBlock) {
            return 0.528;
        }
        return 0.0;
    }

    public static boolean hasBlockSolidSide(BlockState p_220056_0_, BlockGetter p_220056_1_, BlockPos p_220056_2_, Direction p_220056_3_) {
        return !p_220056_0_.is(BlockTags.LEAVES) && Block.isFaceFull((VoxelShape)p_220056_0_.getCollisionShape(p_220056_1_, p_220056_2_), (Direction)p_220056_3_);
    }

    public static BlockState copyProperties(BlockState fromState, BlockState toState) {
        for (Property property : fromState.getProperties()) {
            toState = BlockHelper.copyProperty(property, fromState, toState);
        }
        return toState;
    }

    public static <T extends Comparable<T>> BlockState copyProperty(Property<T> property, BlockState fromState, BlockState toState) {
        if (fromState.hasProperty(property) && toState.hasProperty(property)) {
            return (BlockState)toState.setValue(property, fromState.getValue(property));
        }
        return toState;
    }
}

