/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.gui.TemplateSlot;

public class DiamondRandomizerBagContainer
extends AbstractContainerMenu {
    private static final int INV_START = 27;
    private static final int INV_END = 53;
    private static final int HOTBAR_START = 54;
    private static final int HOTBAR_END = 62;
    private final IItemHandler bagInventory;

    public DiamondRandomizerBagContainer(MenuType<?> type, int id) {
        super(type, id);
        this.bagInventory = null;
    }

    public DiamondRandomizerBagContainer(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory);
    }

    public DiamondRandomizerBagContainer(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (IItemHandler)new ItemStackHandler(27));
    }

    public DiamondRandomizerBagContainer(int containerId, Inventory playerInventory, IItemHandler inventory) {
        super(SophisticatedBuilding.DIAMOND_RANDOMIZER_BAG_CONTAINER.get(), containerId);
        int i;
        this.bagInventory = inventory;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot((Slot)new TemplateSlot(this.bagInventory, x + y * 9, 8 + x * 18, 18 + y * 18, 27));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public Slot getSlot(int parSlotIndex) {
        if (parSlotIndex >= this.slots.size()) {
            parSlotIndex = this.slots.size() - 1;
        }
        return super.getSlot(parSlotIndex);
    }

    public ItemStack quickMoveStack(Player playerIn, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotIndex < 27) {
                if (!this.moveItemStackTo(itemstack1, 27, 63, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (slotIndex >= 27 && !this.moveItemStackTo(itemstack1, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void clicked(int slot, int dragType, ClickType clickTypeIn, Player player) {
        if (slot >= 0 && this.getSlot(slot) != null && this.getSlot(slot).getItem().equals(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return;
        }
        super.clicked(slot, dragType, clickTypeIn, player);
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide) {
            this.broadcastChanges();
        }
    }
}

