/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.gui.TemplateSlot;

public class GoldenRandomizerBagContainer
extends AbstractContainerMenu {
    private static final int INV_START = 9;
    private static final int INV_END = 35;
    private static final int HOTBAR_START = 36;
    private static final int HOTBAR_END = 44;
    private final IItemHandler bagInventory;

    public GoldenRandomizerBagContainer(MenuType<?> type, int id) {
        super(type, id);
        this.bagInventory = null;
    }

    public GoldenRandomizerBagContainer(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory);
    }

    public GoldenRandomizerBagContainer(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (IItemHandler)new ItemStackHandler(9));
    }

    public GoldenRandomizerBagContainer(int containerId, Inventory playerInventory, IItemHandler inventory) {
        super(SophisticatedBuilding.GOLDEN_RANDOMIZER_BAG_CONTAINER.get(), containerId);
        int i;
        this.bagInventory = inventory;
        for (i = 0; i < 9; ++i) {
            this.addSlot((Slot)new TemplateSlot(this.bagInventory, i, 8 + 18 * i, 20, 9));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 51 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 109));
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public Slot getSlot(int parSlotIndex) {
        if (parSlotIndex >= this.slots.size()) {
            parSlotIndex = this.slots.size() - 1;
        }
        return super.getSlot(parSlotIndex);
    }

    public ItemStack quickMoveStack(Player playerIn, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotIndex < 9) {
                if (!this.moveItemStackTo(itemstack1, 9, 45, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (slotIndex >= 9 && !this.moveItemStackTo(itemstack1, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void clicked(int slot, int dragType, ClickType clickTypeIn, Player player) {
        if (slot >= 0 && this.getSlot(slot) != null && this.getSlot(slot).getItem().equals(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return;
        }
        super.clicked(slot, dragType, clickTypeIn, player);
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide) {
            this.broadcastChanges();
        }
    }
}

