/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.gui.GoldenRandomizerBagContainer;
import sophisticated.building.utilities.InventoryHelper;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class GoldenRandomizerBagScreen
extends AbstractContainerScreen<GoldenRandomizerBagContainer> {
    private Inventory inventory;
    private static final ResourceLocation guiTextures = SophisticatedBuilding.asResource("textures/gui/container/goldenrandomizerbag.png");
    private static final int MISSING_ITEM_COLOR = -2130771968;

    public GoldenRandomizerBagScreen(GoldenRandomizerBagContainer randomizerBagContainer, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)randomizerBagContainer, playerInventory, title);
        this.inventory = playerInventory;
        this.imageHeight = 134;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int marginHorizontal = (this.width - this.imageWidth) / 2;
        int marginVertical = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(guiTextures, marginHorizontal, marginVertical, 0, 0, this.imageWidth, this.imageHeight);
        this.renderMissingItemOverlays(guiGraphics);
    }

    protected void renderMissingItemOverlays(GuiGraphics guiGraphics) {
        Set<Item> missingItems = this.getMissingItems();
        if (missingItems.isEmpty()) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            Slot slot = ((GoldenRandomizerBagContainer)this.menu).getSlot(i);
            ItemStack stack = slot.getItem();
            if (stack.isEmpty() || !missingItems.contains(stack.getItem())) continue;
            int x = this.leftPos + slot.x;
            int y = this.topPos + slot.y;
            guiGraphics.fill(x, y, x + 16, y + 16, -2130771968);
        }
    }

    protected Set<Item> getMissingItems() {
        HashSet<Item> missing = new HashSet<Item>();
        if (this.inventory.player.isCreative()) {
            return missing;
        }
        for (int i = 0; i < 9; ++i) {
            int available;
            Slot slot = ((GoldenRandomizerBagContainer)this.menu).getSlot(i);
            ItemStack stack = slot.getItem();
            if (stack.isEmpty() || (available = InventoryHelper.findTotalItemsInInventory(this.inventory.player, stack.getItem())) > 0) continue;
            missing.add(stack.getItem());
        }
        return missing;
    }
}

