/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.gui.TemplateSlot;
import sophisticated.building.item.OmegaRandomizerBagItem;

public class OmegaRandomizerBagContainer
extends AbstractContainerMenu {
    private static final int INV_START = 54;
    private static final int INV_END = 80;
    private static final int HOTBAR_START = 81;
    private static final int HOTBAR_END = 89;
    private final IItemHandler bagInventory;

    public OmegaRandomizerBagContainer(MenuType<?> type, int id) {
        super(type, id);
        this.bagInventory = null;
    }

    public OmegaRandomizerBagContainer(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory);
    }

    public OmegaRandomizerBagContainer(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (IItemHandler)new ItemStackHandler(54));
    }

    public OmegaRandomizerBagContainer(int containerId, Inventory playerInventory, IItemHandler inventory) {
        super(SophisticatedBuilding.OMEGA_RANDOMIZER_BAG_CONTAINER.get(), containerId);
        int i;
        this.bagInventory = inventory;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot((Slot)new TemplateSlot(this.bagInventory, x + y * 9, 8 + x * 18, 18 + y * 18, 54));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 139 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 197));
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public Slot getSlot(int parSlotIndex) {
        if (parSlotIndex >= this.slots.size()) {
            parSlotIndex = this.slots.size() - 1;
        }
        return super.getSlot(parSlotIndex);
    }

    public ItemStack quickMoveStack(Player playerIn, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotIndex < 54) {
                if (!this.moveItemStackTo(itemstack1, 54, 90, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (slotIndex >= 54 && !this.moveItemStackTo(itemstack1, 0, 54, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        ItemStack stack;
        if (clickTypeIn == ClickType.SWAP && !(stack = player.getInventory().getItem(dragType)).isEmpty() && stack.getItem() instanceof OmegaRandomizerBagItem) {
            return;
        }
        if (slotId >= 0 && slotId < this.slots.size()) {
            Slot slot = (Slot)this.slots.get(slotId);
            ItemStack heldStack = player.containerMenu.getCarried();
            if (!heldStack.isEmpty() && heldStack.getItem() instanceof OmegaRandomizerBagItem && slot.container != player.getInventory()) {
                return;
            }
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }
}

