/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.gui.OmegaRandomizerBagContainer;
import sophisticated.building.item.OmegaRandomizerBagItem;
import sophisticated.building.network.message.OmegaBagWeightPacket;
import sophisticated.building.utilities.InventoryHelper;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class OmegaRandomizerBagScreen
extends AbstractContainerScreen<OmegaRandomizerBagContainer> {
    private Inventory inventory;
    private static final ResourceLocation guiTextures = SophisticatedBuilding.asResource("textures/gui/container/omegarandomizerbag.png");
    private static final int MISSING_ITEM_COLOR = -2130771968;
    private Button resetWeightsButton;

    public OmegaRandomizerBagScreen(OmegaRandomizerBagContainer randomizerBagContainer, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)randomizerBagContainer, playerInventory, title);
        this.inventory = playerInventory;
        this.imageHeight = 221;
        this.imageWidth = 176;
    }

    protected void init() {
        super.init();
        int buttonX = this.leftPos + this.imageWidth + 4;
        int buttonY = this.topPos + 4;
        this.resetWeightsButton = Button.builder((Component)Component.literal((String)"Reset"), this::onResetWeightsPressed).bounds(buttonX, buttonY, 40, 16).build();
        this.addRenderableWidget((GuiEventListener)this.resetWeightsButton);
    }

    private void onResetWeightsPressed(Button button) {
        ItemStack heldBag = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND);
        Item item = heldBag.getItem();
        if (item instanceof OmegaRandomizerBagItem) {
            OmegaRandomizerBagItem omegaBag = (OmegaRandomizerBagItem)item;
            for (int i = 0; i < 54; ++i) {
                int currentWeight;
                Slot slot = ((OmegaRandomizerBagContainer)this.menu).getSlot(i);
                if (slot.getItem().isEmpty() || (currentWeight = omegaBag.getSlotWeight(heldBag, i)) == 1) continue;
                PacketDistributor.sendToServer((CustomPacketPayload)new OmegaBagWeightPacket(i, 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                omegaBag.setSlotWeight(heldBag, i, 1);
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderWeightBadges(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (int i = 0; i < 54; ++i) {
            Slot slot = ((OmegaRandomizerBagContainer)this.menu).getSlot(i);
            int slotX = this.leftPos + slot.x;
            int slotY = this.topPos + slot.y;
            if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 16))) continue;
            ItemStack heldBag = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND);
            Item item = heldBag.getItem();
            if (item instanceof OmegaRandomizerBagItem) {
                int currentWeight;
                OmegaRandomizerBagItem omegaBag = (OmegaRandomizerBagItem)item;
                int newWeight = currentWeight = omegaBag.getSlotWeight(heldBag, i);
                if (scrollY > 0.0) {
                    if (currentWeight == 1) {
                        newWeight = 2;
                    } else if (currentWeight == 2) {
                        newWeight = 3;
                    } else if (currentWeight == 3) {
                        newWeight = 5;
                    } else if (currentWeight == 5) {
                        newWeight = 10;
                    }
                } else if (scrollY < 0.0) {
                    if (currentWeight == 10) {
                        newWeight = 5;
                    } else if (currentWeight == 5) {
                        newWeight = 3;
                    } else if (currentWeight == 3) {
                        newWeight = 2;
                    } else if (currentWeight == 2) {
                        newWeight = 1;
                    }
                }
                if (newWeight != currentWeight) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new OmegaBagWeightPacket(i, newWeight), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    omegaBag.setSlotWeight(heldBag, i, newWeight);
                }
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 94, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int marginHorizontal = (this.width - this.imageWidth) / 2;
        int marginVertical = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(guiTextures, marginHorizontal, marginVertical, 0, 0, this.imageWidth, this.imageHeight);
        this.renderMissingItemOverlays(guiGraphics);
    }

    protected void renderMissingItemOverlays(GuiGraphics guiGraphics) {
        Set<Item> missingItems = this.getMissingItems();
        if (missingItems.isEmpty()) {
            return;
        }
        for (int i = 0; i < 54; ++i) {
            Slot slot = ((OmegaRandomizerBagContainer)this.menu).getSlot(i);
            ItemStack stack = slot.getItem();
            if (stack.isEmpty() || !missingItems.contains(stack.getItem())) continue;
            int x = this.leftPos + slot.x;
            int y = this.topPos + slot.y;
            guiGraphics.fill(x, y, x + 16, y + 16, -2130771968);
        }
    }

    protected Set<Item> getMissingItems() {
        HashSet<Item> missing = new HashSet<Item>();
        if (this.inventory.player.isCreative()) {
            return missing;
        }
        for (int i = 0; i < 54; ++i) {
            int available;
            Slot slot = ((OmegaRandomizerBagContainer)this.menu).getSlot(i);
            ItemStack stack = slot.getItem();
            if (stack.isEmpty() || (available = InventoryHelper.findTotalItemsInInventory(this.inventory.player, stack.getItem())) > 0) continue;
            missing.add(stack.getItem());
        }
        return missing;
    }

    protected void renderWeightBadges(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Slot slot;
        int i;
        ItemStack heldBag = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND);
        Item item = heldBag.getItem();
        if (!(item instanceof OmegaRandomizerBagItem)) {
            return;
        }
        OmegaRandomizerBagItem omegaBag = (OmegaRandomizerBagItem)item;
        Font font = Minecraft.getInstance().font;
        PoseStack ms = guiGraphics.pose();
        int totalWeight = 0;
        int[] weights = new int[54];
        for (i = 0; i < 54; ++i) {
            slot = ((OmegaRandomizerBagContainer)this.menu).getSlot(i);
            if (slot.getItem().isEmpty()) continue;
            weights[i] = omegaBag.getSlotWeight(heldBag, i);
            totalWeight += weights[i];
        }
        for (i = 0; i < 54; ++i) {
            slot = ((OmegaRandomizerBagContainer)this.menu).getSlot(i);
            if (slot.getItem().isEmpty()) continue;
            int weight = weights[i];
            int slotX = this.leftPos + slot.x;
            int slotY = this.topPos + slot.y;
            ms.pushPose();
            ms.translate(0.0f, 0.0f, 400.0f);
            String weightText = String.valueOf(weight);
            int textWidth = font.width(weightText);
            int badgeX = slotX + 16 - textWidth - 2;
            int badgeY = slotY + 1;
            Objects.requireNonNull(font);
            int badgeHeight = 9;
            int color = weight == 1 ? -1 : (weight <= 3 ? -256 : (weight == 5 ? -22016 : -43776));
            RenderSystem.disableDepthTest();
            guiGraphics.fill(badgeX - 2, badgeY - 1, badgeX + textWidth + 2, badgeY + badgeHeight, -1442840576);
            RenderSystem.enableDepthTest();
            MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
            font.drawInBatch(weightText, (float)badgeX, (float)badgeY, color, true, ms.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            buffer.endBatch();
            ms.popPose();
            if (mouseX < slotX || mouseX >= slotX + 16 || mouseY < slotY || mouseY >= slotY + 16 || totalWeight <= 0) continue;
            float percentage = (float)weight * 100.0f / (float)totalWeight;
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.literal((String)("Weight: " + weight)).withStyle(ChatFormatting.GOLD));
            tooltip.add(Component.literal((String)String.format("Chance: %.1f%%", Float.valueOf(percentage))).withStyle(ChatFormatting.YELLOW));
            tooltip.add(Component.literal((String)"Scroll to adjust").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
            guiGraphics.renderComponentTooltip(font, tooltip, mouseX + 12, mouseY + 24);
        }
    }
}

