/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui.buildmodifier;

import java.util.Vector;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sophisticated.building.AllGuiTextures;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.buildmodifier.Array;
import sophisticated.building.buildmodifier.BaseModifier;
import sophisticated.building.create.foundation.gui.widget.ScrollInput;
import sophisticated.building.gui.buildmodifier.BaseModifierEntry;
import sophisticated.building.gui.buildmodifier.ModifiersScreen;
import sophisticated.building.gui.elements.LabeledScrollInput;
import sophisticated.building.utilities.MathHelper;

@OnlyIn(value=Dist.CLIENT)
public class ArrayEntry
extends BaseModifierEntry<Array> {
    protected Vector<ScrollInput> offsetInputs = new Vector(3);
    protected ScrollInput countInput;

    public ArrayEntry(ModifiersScreen screen, BaseModifier array) {
        super(screen, (Array)array, (Component)Component.literal((String)"Array"), AllGuiTextures.ARRAY_ENTRY);
        int i;
        this.offsetInputs.clear();
        for (i = 0; i < 3; ++i) {
            int index = i;
            ScrollInput scrollInput = new LabeledScrollInput(0, 0, 18, 18).titled(Component.literal((String)(i == 0 ? "X Offset" : (i == 1 ? "Y Offset" : "Z Offset")))).calling(value -> {
                ((Array)this.modifier).offset = MathHelper.with(((Array)this.modifier).offset, index, value);
                this.onValueChanged();
            });
            scrollInput.setState(MathHelper.get(((Array)this.modifier).offset, index));
            this.offsetInputs.add(scrollInput);
        }
        this.listeners.addAll(this.offsetInputs);
        this.countInput = new LabeledScrollInput(0, 0, 18, 18).withRange(1, 100).titled(Component.literal((String)"Count")).calling(value -> {
            ((Array)this.modifier).count = value;
            this.onValueChanged();
        });
        this.countInput.setState(((Array)this.modifier).count);
        this.listeners.add(this.countInput);
        for (i = 0; i < 3; ++i) {
            this.offsetInputs.get(i).onChanged();
        }
        this.countInput.onChanged();
        this.onValueChanged();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTicks) {
        super.render(guiGraphics, index, y, x, width, height, mouseX, mouseY, hovering, partialTicks);
        for (int i = 0; i < 3; ++i) {
            this.offsetInputs.get(i).setX(this.left + 49 + 20 * i);
            this.offsetInputs.get(i).setY(this.top + 19);
            this.offsetInputs.get(i).render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.countInput.setX(this.left + 49);
        this.countInput.setY(this.top + 41);
        this.countInput.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.reachLabel.setX(this.right - 8 - this.getFont().width((FormattedText)this.reachLabel.text));
        this.reachLabel.setY(this.top + 24);
        this.reachLabel.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onValueChanged() {
        super.onValueChanged();
        int currentReach = Math.max(-1, this.getArrayReach());
        int maxReach = AttachmentHandler.getMaxBlocksPerAxis((Player)Minecraft.getInstance().player, false);
        ChatFormatting reachColor = this.isCurrentReachValid(currentReach, maxReach) ? ChatFormatting.GRAY : ChatFormatting.RED;
        String reachText = String.valueOf(reachColor) + currentReach + String.valueOf(ChatFormatting.GRAY) + "/" + String.valueOf(ChatFormatting.GRAY) + maxReach;
        this.reachLabel.text = Component.literal((String)reachText);
    }

    private int getArrayReach() {
        try {
            double x = Math.abs(((Array)this.modifier).offset.getX());
            double y = Math.abs(((Array)this.modifier).offset.getY());
            double z = Math.abs(((Array)this.modifier).offset.getZ());
            double largestOffset = Math.max(Math.max(x, y), z);
            return (int)(largestOffset * (double)((Array)this.modifier).count);
        }
        catch (NullPointerException | NumberFormatException ex) {
            return -1;
        }
    }

    private boolean isCurrentReachValid(int currentReach, int maxReach) {
        return currentReach <= maxReach && currentReach > -1;
    }
}

