/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui.buildmodifier;

import java.text.DecimalFormat;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sophisticated.building.AllGuiTextures;
import sophisticated.building.AllIcons;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.buildmodifier.BaseModifier;
import sophisticated.building.buildmodifier.Mirror;
import sophisticated.building.create.foundation.gui.widget.IconButton;
import sophisticated.building.create.foundation.gui.widget.ScrollInput;
import sophisticated.building.create.foundation.utility.Components;
import sophisticated.building.gui.buildmodifier.BaseModifierEntry;
import sophisticated.building.gui.buildmodifier.ModifiersScreen;
import sophisticated.building.gui.elements.LabeledScrollInput;
import sophisticated.building.utilities.MathHelper;

@OnlyIn(value=Dist.CLIENT)
public class MirrorEntry
extends BaseModifierEntry<Mirror> {
    protected Vector<ScrollInput> positionInputs;
    protected IconButton playerPositionButton;
    protected IconButton toggleOffsetButton;
    protected Vector<IconButton> axisButtons;
    protected ScrollInput radiusInput;
    protected IconButton showLinesButton;
    protected IconButton showAreasButton;
    protected DecimalFormat df = new DecimalFormat("#.#");

    public MirrorEntry(ModifiersScreen screen, BaseModifier mirror) {
        super(screen, (Mirror)mirror, (Component)Component.literal((String)"Mirror"), AllGuiTextures.MIRROR_ENTRY);
        int index;
        int i;
        this.positionInputs = new Vector();
        this.axisButtons = new Vector();
        for (i = 0; i < 3; ++i) {
            index = i;
            ScrollInput scrollInput = new LabeledScrollInput(0, 0, 36, 18).showControlScrollsSlowerTooltip().titled(Component.literal((String)(i == 0 ? "X Position" : (i == 1 ? "Y Position" : "Z Position")))).format(integer -> Component.literal((String)this.df.format((double)integer.intValue() / 2.0))).withStepFunction(stepContext -> stepContext.shift ? 20 : (stepContext.control ? 1 : 2)).calling(value -> {
                ((Mirror)this.modifier).position = MathHelper.with(((Mirror)this.modifier).position, index, (double)value.intValue() / 2.0);
                this.onValueChanged();
            });
            scrollInput.setState((int)(MathHelper.get(((Mirror)this.modifier).position, index) * 2.0));
            this.positionInputs.add(scrollInput);
        }
        this.listeners.addAll(this.positionInputs);
        this.playerPositionButton = (IconButton)((Object)new IconButton(0, 0, AllIcons.I_PLAYER).withCallback(() -> {
            ((Mirror)this.modifier).position = Vec3.atLowerCornerOf((Vec3i)Minecraft.getInstance().player.blockPosition());
            this.onValueChanged();
        }));
        this.playerPositionButton.setToolTip((Component)Components.literal("Set to player position"));
        this.listeners.add(this.playerPositionButton);
        this.toggleOffsetButton = (IconButton)((Object)new IconButton(0, 0, AllIcons.I_BLOCK_CENTER).withCallback(() -> {
            ((Mirror)this.modifier).position = ((Mirror)this.modifier).position.x == Math.floor(((Mirror)this.modifier).position.x) ? new Vec3(Math.floor(((Mirror)this.modifier).position.x) + 0.5, Math.floor(((Mirror)this.modifier).position.y) + 0.5, Math.floor(((Mirror)this.modifier).position.z) + 0.5) : new Vec3(Math.floor(((Mirror)this.modifier).position.x), Math.floor(((Mirror)this.modifier).position.y), Math.floor(((Mirror)this.modifier).position.z));
            this.onValueChanged();
        }));
        this.listeners.add(this.toggleOffsetButton);
        for (i = 0; i < 3; ++i) {
            index = i;
            IconButton button = (IconButton)((Object)new IconButton(0, 0, i == 0 ? AllIcons.I_X_ON : (i == 1 ? AllIcons.I_Y_OFF : AllIcons.I_Z_OFF)).withCallback(() -> {
                ((Mirror)this.modifier).toggleMirrorAxis(index);
                this.onValueChanged();
            }));
            button.setToolTip((Component)Components.literal(i == 0 ? "X Axis" : (i == 1 ? "Y Axis" : "Z Axis")));
            this.axisButtons.add(button);
        }
        this.listeners.addAll(this.axisButtons);
        this.radiusInput = new LabeledScrollInput(0, 0, 27, 18).withRange(0, AttachmentHandler.getMaxMirrorRadius((Player)Minecraft.getInstance().player, false)).titled(Minecraft.getInstance().player.isCreative() ? Component.literal((String)"Radius") : Component.literal((String)"Radius. Use Reach Upgrade items to increase maximum.")).calling(value -> {
            ((Mirror)this.modifier).radius = value;
            this.onValueChanged();
        });
        this.radiusInput.setState(((Mirror)this.modifier).radius);
        this.listeners.add(this.radiusInput);
        this.showLinesButton = (IconButton)((Object)new IconButton(0, 0, AllIcons.I_SHOW_LINES).withCallback(() -> {
            ((Mirror)this.modifier).drawLines = !((Mirror)this.modifier).drawLines;
            this.onValueChanged();
        }));
        this.listeners.add(this.showLinesButton);
        this.showAreasButton = (IconButton)((Object)new IconButton(0, 0, AllIcons.I_SHOW_AREAS).withCallback(() -> {
            ((Mirror)this.modifier).drawPlanes = !((Mirror)this.modifier).drawPlanes;
            this.onValueChanged();
        }));
        this.listeners.add(this.showAreasButton);
        for (ScrollInput positionInput : this.positionInputs) {
            positionInput.onChanged();
        }
        this.radiusInput.onChanged();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTicks) {
        int i;
        super.render(guiGraphics, index, y, x, width, height, mouseX, mouseY, hovering, partialTicks);
        for (i = 0; i < 3; ++i) {
            ScrollInput input = this.positionInputs.get(i);
            input.setX(this.left + 49 + 38 * i);
            input.setY(this.top + 19);
            input.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.playerPositionButton.setX(this.left + 163);
        this.playerPositionButton.setY(this.top + 19);
        this.playerPositionButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.toggleOffsetButton.setX(this.left + 183);
        this.toggleOffsetButton.setY(this.top + 19);
        this.toggleOffsetButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (i = 0; i < 3; ++i) {
            IconButton button = this.axisButtons.get(i);
            button.setX(this.left + 49 + 18 * i);
            button.setY(this.top + 41);
            button.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.radiusInput.setX(this.left + 134);
        this.radiusInput.setY(this.top + 41);
        this.radiusInput.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.showLinesButton.setX(this.left + 163);
        this.showLinesButton.setY(this.top + 41);
        this.showLinesButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.showAreasButton.setX(this.left + 183);
        this.showAreasButton.setY(this.top + 41);
        this.showAreasButton.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onValueChanged() {
        int i;
        super.onValueChanged();
        for (i = 0; i < 3; ++i) {
            ScrollInput input = this.positionInputs.get(i);
            input.setState((int)(MathHelper.get(((Mirror)this.modifier).position, i) * 2.0));
        }
        if (((Mirror)this.modifier).position.x == Math.floor(((Mirror)this.modifier).position.x)) {
            this.toggleOffsetButton.setIcon(AllIcons.I_BLOCK_CENTER);
            this.toggleOffsetButton.setToolTip((Component)Components.literal("Set position to center of block, for uneven numbered builds."));
        } else {
            this.toggleOffsetButton.setIcon(AllIcons.I_BLOCK_CORNER);
            this.toggleOffsetButton.setToolTip((Component)Components.literal("Set position to corner of block, for even numbered builds."));
        }
        for (i = 0; i < 3; ++i) {
            IconButton button = this.axisButtons.get(i);
            if (((Mirror)this.modifier).getMirrorAxis(i)) {
                button.setIcon(i == 0 ? AllIcons.I_X_ON : (i == 1 ? AllIcons.I_Y_ON : AllIcons.I_Z_ON));
                continue;
            }
            button.setIcon(i == 0 ? AllIcons.I_X_OFF : (i == 1 ? AllIcons.I_Y_OFF : AllIcons.I_Z_OFF));
        }
        if (((Mirror)this.modifier).drawLines) {
            this.showLinesButton.setIcon(AllIcons.I_SHOW_LINES);
            this.showLinesButton.setToolTip((Component)Components.literal("Show mirror lines"));
        } else {
            this.showLinesButton.setIcon(AllIcons.I_HIDE_LINES);
            this.showLinesButton.setToolTip((Component)Components.literal("Show mirror lines"));
        }
        if (((Mirror)this.modifier).drawPlanes) {
            this.showAreasButton.setIcon(AllIcons.I_SHOW_AREAS);
            this.showAreasButton.setToolTip((Component)Components.literal("Show mirror areas"));
        } else {
            this.showAreasButton.setIcon(AllIcons.I_HIDE_AREAS);
            this.showAreasButton.setToolTip((Component)Components.literal("Show mirror areas"));
        }
    }
}

