/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui.buildmodifier;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.createmod.catnip.gui.element.FadableScreenElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sophisticated.building.ClientEvents;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.buildmodifier.Array;
import sophisticated.building.buildmodifier.BaseModifier;
import sophisticated.building.buildmodifier.Mirror;
import sophisticated.building.buildmodifier.RadialMirror;
import sophisticated.building.create.foundation.gui.AbstractSimiScreen;
import sophisticated.building.create.foundation.gui.AllIcons;
import sophisticated.building.create.foundation.utility.Components;
import sophisticated.building.gui.buildmodifier.ArrayEntry;
import sophisticated.building.gui.buildmodifier.BaseModifierEntry;
import sophisticated.building.gui.buildmodifier.MirrorEntry;
import sophisticated.building.gui.buildmodifier.ModifiersScreenList;
import sophisticated.building.gui.buildmodifier.RadialMirrorEntry;

@OnlyIn(value=Dist.CLIENT)
public class ModifiersScreen
extends AbstractSimiScreen {
    protected ModifiersScreenList list;
    protected BoxWidget addArrayButton;
    protected BoxWidget addMirrorButton;
    protected BoxWidget addRadialMirrorButton;
    protected BoxWidget closeButton;

    public ModifiersScreen() {
        super((Component)Component.translatable((String)"sophisticatedbuilding.screen.modifier_settings"));
    }

    @Override
    protected void init() {
        super.init();
        int listWidth = Math.min(this.width - 80, 300);
        int yCenter = this.height / 2;
        int listL = this.width / 2 - listWidth / 2;
        int listR = this.width / 2 + listWidth / 2;
        this.list = new ModifiersScreenList(this.minecraft, listWidth, this.height - 80, 45, 68);
        this.list.setX(this.width / 2 - this.list.getWidth() / 2);
        this.addRenderableWidget((GuiEventListener)this.list);
        this.initScrollEntries();
        this.addArrayButton = (BoxWidget)new BoxWidget(listR - 90, 10, 20, 20).withPadding(2.0f, 2.0f).withCallback(() -> this.addModifier(new Array()));
        this.addArrayButton.showingElement((RenderElement)AllIcons.I_ADD.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(this.addArrayButton)));
        this.addArrayButton.getToolTip().add(Components.literal("Add Array"));
        this.addMirrorButton = (BoxWidget)new BoxWidget(listR - 60, 10, 20, 20).withPadding(2.0f, 2.0f).withCallback(() -> this.addModifier(new Mirror()));
        this.addMirrorButton.showingElement((RenderElement)AllIcons.I_ADD.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(this.addMirrorButton)));
        this.addMirrorButton.getToolTip().add(Components.literal("Add Mirror"));
        this.addRadialMirrorButton = (BoxWidget)new BoxWidget(listR - 30, 10, 20, 20).withPadding(2.0f, 2.0f).withCallback(() -> this.addModifier(new RadialMirror()));
        this.addRadialMirrorButton.showingElement((RenderElement)AllIcons.I_ADD.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(this.addRadialMirrorButton)));
        this.addRadialMirrorButton.getToolTip().add(Components.literal("Add Radial Mirror"));
        this.closeButton = (BoxWidget)new BoxWidget(listL - 30, yCenter - 10, 20, 20).withPadding(2.0f, 2.0f).withCallback(this::onClose);
        this.closeButton.showingElement((RenderElement)AllIcons.I_CONFIG_BACK.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(this.closeButton)));
        this.closeButton.getToolTip().add(Components.literal("Close"));
        this.addRenderableWidget((GuiEventListener)this.addArrayButton);
        this.addRenderableWidget((GuiEventListener)this.addMirrorButton);
        this.addRenderableWidget((GuiEventListener)this.addRadialMirrorButton);
        this.addRenderableWidget((GuiEventListener)this.closeButton);
    }

    private void initScrollEntries() {
        this.list.children().clear();
        List<BaseModifier> modifierSettingsList = SophisticatedBuildingClient.BUILD_MODIFIERS.getModifierSettingsList();
        for (BaseModifier modifier : modifierSettingsList) {
            BaseModifierEntry entry = this.createModifierPanel(modifier);
            this.list.children().add(entry);
        }
    }

    private BaseModifierEntry createModifierPanel(BaseModifier modifier) {
        if (modifier instanceof Mirror) {
            return new MirrorEntry(this, modifier);
        }
        if (modifier instanceof Array) {
            return new ArrayEntry(this, modifier);
        }
        if (modifier instanceof RadialMirror) {
            return new RadialMirrorEntry(this, modifier);
        }
        return null;
    }

    private void addModifier(BaseModifier modifier) {
        BaseModifierEntry entry = this.createModifierPanel(modifier);
        this.list.children().add(entry);
        SophisticatedBuildingClient.BUILD_MODIFIERS.addModifierSettings(modifier);
    }

    public void removeModifier(BaseModifierEntry entry) {
        this.list.children().remove((Object)entry);
        SophisticatedBuildingClient.BUILD_MODIFIERS.removeModifierSettings((BaseModifier)entry.modifier);
    }

    public boolean canMoveUp(BaseModifierEntry modifierEntry) {
        int index = this.list.children().indexOf((Object)modifierEntry);
        return index > 0;
    }

    public boolean canMoveDown(BaseModifierEntry modifierEntry) {
        int index = this.list.children().indexOf((Object)modifierEntry);
        return index < this.list.children().size() - 1;
    }

    public void moveModifierUp(BaseModifierEntry modifierEntry) {
        int index = this.list.children().indexOf((Object)modifierEntry);
        if (index == 0) {
            return;
        }
        Collections.swap(this.list.children(), index, index - 1);
        SophisticatedBuildingClient.BUILD_MODIFIERS.moveUp((BaseModifier)modifierEntry.modifier);
    }

    public void moveModifierDown(BaseModifierEntry modifierEntry) {
        int index = this.list.children().indexOf((Object)modifierEntry);
        if (index == this.list.children().size() - 1) {
            return;
        }
        Collections.swap(this.list.children(), index, index + 1);
        SophisticatedBuildingClient.BUILD_MODIFIERS.moveDown((BaseModifier)modifierEntry.modifier);
    }

    public void resize(@Nonnull Minecraft client, int width, int height) {
        double scroll = this.list.getScrollAmount();
        this.init(client, width, height);
        this.list.setScrollAmount(scroll);
    }

    @Override
    protected void renderWindow(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void onClose() {
        super.onClose();
        SophisticatedBuildingClient.BUILD_MODIFIERS.save();
    }

    @Override
    public boolean keyPressed(int keyCode, int p_96553_, int p_96554_) {
        if (keyCode == ClientEvents.keyBindings[1].getKey().getValue()) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, p_96553_, p_96554_);
    }
}

