/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui.buildmodifier;

import java.text.DecimalFormat;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sophisticated.building.AllGuiTextures;
import sophisticated.building.AllIcons;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.buildmodifier.BaseModifier;
import sophisticated.building.buildmodifier.RadialMirror;
import sophisticated.building.create.foundation.gui.widget.IconButton;
import sophisticated.building.create.foundation.gui.widget.ScrollInput;
import sophisticated.building.create.foundation.utility.Components;
import sophisticated.building.gui.buildmodifier.BaseModifierEntry;
import sophisticated.building.gui.buildmodifier.ModifiersScreen;
import sophisticated.building.gui.elements.LabeledScrollInput;
import sophisticated.building.utilities.MathHelper;

@OnlyIn(value=Dist.CLIENT)
public class RadialMirrorEntry
extends BaseModifierEntry<RadialMirror> {
    protected Vector<ScrollInput> positionInputs;
    protected IconButton playerPositionButton;
    protected IconButton toggleOffsetButton;
    protected ScrollInput slicesInput;
    protected IconButton alternateButton;
    protected ScrollInput radiusInput;
    protected IconButton showLinesButton;
    protected IconButton showAreasButton;
    protected DecimalFormat df = new DecimalFormat("#.#");

    public RadialMirrorEntry(ModifiersScreen screen, BaseModifier radialMirror) {
        super(screen, (RadialMirror)radialMirror, (Component)Component.literal((String)"Radial Mirror"), AllGuiTextures.RADIAL_MIRROR_ENTRY);
        this.positionInputs = new Vector();
        for (int i = 0; i < 3; ++i) {
            int index = i;
            ScrollInput scrollInput = new LabeledScrollInput(0, 0, 36, 18).showControlScrollsSlowerTooltip().titled(Component.literal((String)(i == 0 ? "X Position" : (i == 1 ? "Y Position" : "Z Position")))).format(integer -> Component.literal((String)this.df.format((double)integer.intValue() / 2.0))).withStepFunction(stepContext -> stepContext.shift ? 20 : (stepContext.control ? 1 : 2)).calling(value -> {
                ((RadialMirror)this.modifier).position = MathHelper.with(((RadialMirror)this.modifier).position, index, (double)value.intValue() / 2.0);
                this.onValueChanged();
            });
            scrollInput.setState((int)(MathHelper.get(((RadialMirror)this.modifier).position, index) * 2.0));
            this.positionInputs.add(scrollInput);
        }
        this.listeners.addAll(this.positionInputs);
        this.playerPositionButton = (IconButton)((Object)new IconButton(0, 0, AllIcons.I_PLAYER).withCallback(() -> {
            ((RadialMirror)this.modifier).position = Vec3.atLowerCornerOf((Vec3i)Minecraft.getInstance().player.blockPosition());
            this.onValueChanged();
        }));
        this.playerPositionButton.setToolTip((Component)Components.literal("Set to player position"));
        this.listeners.add(this.playerPositionButton);
        this.toggleOffsetButton = (IconButton)((Object)new IconButton(0, 0, AllIcons.I_BLOCK_CENTER).withCallback(() -> {
            ((RadialMirror)this.modifier).position = ((RadialMirror)this.modifier).position.x == Math.floor(((RadialMirror)this.modifier).position.x) ? new Vec3(Math.floor(((RadialMirror)this.modifier).position.x) + 0.5, Math.floor(((RadialMirror)this.modifier).position.y) + 0.5, Math.floor(((RadialMirror)this.modifier).position.z) + 0.5) : new Vec3(Math.floor(((RadialMirror)this.modifier).position.x), Math.floor(((RadialMirror)this.modifier).position.y), Math.floor(((RadialMirror)this.modifier).position.z));
            this.onValueChanged();
        }));
        this.listeners.add(this.toggleOffsetButton);
        this.slicesInput = new LabeledScrollInput(0, 0, 27, 18).withRange(3, 1000).titled(Component.literal((String)"Slices")).calling(value -> {
            ((RadialMirror)this.modifier).slices = value;
            this.onValueChanged();
        });
        this.slicesInput.setState(((RadialMirror)this.modifier).slices);
        this.listeners.add(this.slicesInput);
        this.alternateButton = (IconButton)((Object)new IconButton(0, 0, AllIcons.I_ALTERNATE_OFF).withCallback(() -> {
            ((RadialMirror)this.modifier).alternate = !((RadialMirror)this.modifier).alternate;
            this.onValueChanged();
        }));
        this.listeners.add(this.alternateButton);
        this.radiusInput = new LabeledScrollInput(0, 0, 27, 18).withRange(0, AttachmentHandler.getMaxMirrorRadius((Player)Minecraft.getInstance().player, false)).titled(Minecraft.getInstance().player.isCreative() ? Component.literal((String)"Radius") : Component.literal((String)"Radius. Use Reach Upgrade items to increase maximum.")).calling(value -> {
            ((RadialMirror)this.modifier).radius = value;
            this.onValueChanged();
        });
        this.radiusInput.setState(((RadialMirror)this.modifier).radius);
        this.listeners.add(this.radiusInput);
        this.showLinesButton = (IconButton)((Object)new IconButton(0, 0, AllIcons.I_SHOW_LINES).withCallback(() -> {
            ((RadialMirror)this.modifier).drawLines = !((RadialMirror)this.modifier).drawLines;
            this.onValueChanged();
        }));
        this.listeners.add(this.showLinesButton);
        this.showAreasButton = (IconButton)((Object)new IconButton(0, 0, AllIcons.I_SHOW_AREAS).withCallback(() -> {
            ((RadialMirror)this.modifier).drawPlanes = !((RadialMirror)this.modifier).drawPlanes;
            this.onValueChanged();
        }));
        this.listeners.add(this.showAreasButton);
        for (ScrollInput positionInput : this.positionInputs) {
            positionInput.onChanged();
        }
        this.radiusInput.onChanged();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTicks) {
        super.render(guiGraphics, index, y, x, width, height, mouseX, mouseY, hovering, partialTicks);
        for (int i = 0; i < 3; ++i) {
            ScrollInput input = this.positionInputs.get(i);
            input.setX(this.left + 49 + 38 * i);
            input.setY(this.top + 19);
            input.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.playerPositionButton.setX(this.left + 163);
        this.playerPositionButton.setY(this.top + 19);
        this.playerPositionButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.toggleOffsetButton.setX(this.left + 183);
        this.toggleOffsetButton.setY(this.top + 19);
        this.toggleOffsetButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.slicesInput.setX(this.left + 49);
        this.slicesInput.setY(this.top + 41);
        this.slicesInput.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.alternateButton.setX(this.left + 78);
        this.alternateButton.setY(this.top + 41);
        this.alternateButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.radiusInput.setX(this.left + 134);
        this.radiusInput.setY(this.top + 41);
        this.radiusInput.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.showLinesButton.setX(this.left + 163);
        this.showLinesButton.setY(this.top + 41);
        this.showLinesButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.showAreasButton.setX(this.left + 183);
        this.showAreasButton.setY(this.top + 41);
        this.showAreasButton.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onValueChanged() {
        super.onValueChanged();
        for (int i = 0; i < 3; ++i) {
            ScrollInput input = this.positionInputs.get(i);
            input.setState((int)(MathHelper.get(((RadialMirror)this.modifier).position, i) * 2.0));
        }
        if (((RadialMirror)this.modifier).position.x == Math.floor(((RadialMirror)this.modifier).position.x)) {
            this.toggleOffsetButton.setIcon(AllIcons.I_BLOCK_CENTER);
            this.toggleOffsetButton.setToolTip((Component)Components.literal("Set position to center of block, for uneven numbered builds."));
        } else {
            this.toggleOffsetButton.setIcon(AllIcons.I_BLOCK_CORNER);
            this.toggleOffsetButton.setToolTip((Component)Components.literal("Set position to corner of block, for even numbered builds."));
        }
        if (((RadialMirror)this.modifier).alternate) {
            this.alternateButton.setIcon(AllIcons.I_ALTERNATE_ON);
            this.alternateButton.setToolTip((Component)Components.literal("Alternating the direction of every other slice."));
        } else {
            this.alternateButton.setIcon(AllIcons.I_ALTERNATE_OFF);
            this.alternateButton.setToolTip((Component)Components.literal("Alternate the direction of every other slice. Currently off."));
        }
        if (((RadialMirror)this.modifier).drawLines) {
            this.showLinesButton.setIcon(AllIcons.I_SHOW_LINES);
            this.showLinesButton.setToolTip((Component)Components.literal("Show mirror lines"));
        } else {
            this.showLinesButton.setIcon(AllIcons.I_HIDE_LINES);
            this.showLinesButton.setToolTip((Component)Components.literal("Show mirror lines"));
        }
        if (((RadialMirror)this.modifier).drawPlanes) {
            this.showAreasButton.setIcon(AllIcons.I_SHOW_AREAS);
            this.showAreasButton.setToolTip((Component)Components.literal("Show mirror areas"));
        } else {
            this.showAreasButton.setIcon(AllIcons.I_HIDE_AREAS);
            this.showAreasButton.setToolTip((Component)Components.literal("Show mirror areas"));
        }
    }
}

