/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui.elements;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GuiNumberField {
    public int x;
    public int y;
    public int width;
    public int height;
    public int buttonWidth = 10;
    protected EditBox textField;
    protected Button minusButton;
    protected Button plusButton;
    List<Component> tooltip = new ArrayList<Component>();

    public GuiNumberField(Font font, List<Renderable> renderables, int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textField = new EditBox(font, x + this.buttonWidth + 1, y + 1, width - 2 * this.buttonWidth - 2, height - 2, (Component)Component.empty());
        this.minusButton = Button.builder((Component)Component.literal((String)"-"), button -> {
            float valueChanged = 1.0f;
            if (Screen.hasControlDown()) {
                valueChanged = 5.0f;
            }
            if (Screen.hasShiftDown()) {
                valueChanged = 10.0f;
            }
            this.setNumber(this.getNumber() - (double)valueChanged);
        }).bounds(x, y - 1, this.buttonWidth, height + 2).build();
        this.plusButton = Button.builder((Component)Component.literal((String)"+"), button -> {
            float valueChanged = 1.0f;
            if (Screen.hasControlDown()) {
                valueChanged = 5.0f;
            }
            if (Screen.hasShiftDown()) {
                valueChanged = 10.0f;
            }
            this.setNumber(this.getNumber() + (double)valueChanged);
        }).bounds(x + width - this.buttonWidth, y - 1, this.buttonWidth, height + 2).build();
        renderables.add((Renderable)this.minusButton);
        renderables.add((Renderable)this.plusButton);
    }

    public double getNumber() {
        if (this.textField.getValue().isEmpty()) {
            return 0.0;
        }
        try {
            return DecimalFormat.getInstance().parse(this.textField.getValue()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public void setNumber(double number) {
        this.textField.setValue(DecimalFormat.getInstance().format(number));
    }

    public void setTooltip(Component tooltip) {
        this.setTooltip(Collections.singletonList(tooltip));
    }

    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean flag;
        boolean result = this.textField.mouseClicked(mouseX, mouseY, mouseButton);
        boolean bl = flag = mouseX >= (double)(this.x + this.buttonWidth) && mouseX < (double)(this.x + this.width - this.buttonWidth) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        if (flag && mouseButton == 1) {
            this.textField.setValue("");
            this.textField.setFocused(true);
            result = true;
        }
        return result;
    }

    public void drawNumberField(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.textField.setY(this.y + 1);
        this.minusButton.setY(this.y - 1);
        this.plusButton.setY(this.y - 1);
        this.textField.render(graphics, mouseX, mouseY, partialTicks);
        this.minusButton.render(graphics, mouseX, mouseY, partialTicks);
        this.plusButton.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void drawTooltip(GuiGraphics graphics, Screen screen, int mouseX, int mouseY) {
        boolean insideTextField = mouseX >= this.x + this.buttonWidth && mouseX < this.x + this.width - this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insideMinusButton = mouseX >= this.x && mouseX < this.x + this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insidePlusButton = mouseX >= this.x + this.width - this.buttonWidth && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        ArrayList<Object> textLines = new ArrayList<Object>();
        if (insideTextField) {
            textLines.addAll(this.tooltip);
        }
        if (insideMinusButton) {
            textLines.add(Component.literal((String)"Hold ").append((Component)Component.literal((String)"shift ").withStyle(ChatFormatting.AQUA)).append("for ").append((Component)Component.literal((String)"10").withStyle(ChatFormatting.RED)));
            textLines.add(Component.literal((String)"Hold ").append((Component)Component.literal((String)"ctrl ").withStyle(ChatFormatting.AQUA)).append("for ").append((Component)Component.literal((String)"5").withStyle(ChatFormatting.RED)));
        }
        if (insidePlusButton) {
            textLines.add(Component.literal((String)"Hold ").append((Component)Component.literal((String)"shift ").withStyle(ChatFormatting.DARK_GREEN)).append("for ").append((Component)Component.literal((String)"10").withStyle(ChatFormatting.RED)));
            textLines.add(Component.literal((String)"Hold ").append((Component)Component.literal((String)"ctrl ").withStyle(ChatFormatting.DARK_GREEN)).append("for ").append((Component)Component.literal((String)"5").withStyle(ChatFormatting.RED)));
        }
        graphics.renderComponentTooltip(screen.getMinecraft().font, textLines, mouseX - 10, mouseY + 25);
    }

    public void update() {
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.textField.isFocused()) {
            return false;
        }
        return this.textField.charTyped(typedChar, keyCode);
    }
}

