/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.gui.elements;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import sophisticated.building.create.foundation.gui.widget.Label;
import sophisticated.building.create.foundation.gui.widget.ScrollInput;
import sophisticated.building.create.foundation.utility.Components;
import sophisticated.building.create.foundation.utility.Lang;

public class LabeledScrollInput
extends ScrollInput {
    protected Label label;
    protected final Component controlScrollsSlowerText = Lang.translateDirect("gui.scrollInput.controlScrollsSlower", new Object[0]);
    protected boolean controlScrollsSlower;

    public LabeledScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.min = Integer.MIN_VALUE;
        this.max = Integer.MAX_VALUE;
        this.label = new Label(0, 0, Components.immutableEmpty()).withShadow();
        this.writingTo(this.label);
    }

    public LabeledScrollInput showControlScrollsSlowerTooltip() {
        this.controlScrollsSlower = true;
        return this;
    }

    @Override
    public void doRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTicks);
        this.label.setX(this.getX() + this.width / 2 - Minecraft.getInstance().font.width((FormattedText)this.label.text) / 2);
        int n = this.getY() + this.height / 2;
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.label.setY(n - 9 / 2);
        this.label.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void updateTooltip() {
        super.updateTooltip();
        if (this.title == null || !this.controlScrollsSlower) {
            return;
        }
        this.toolTip.add(this.controlScrollsSlowerText.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
    }
}

