/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.item.OmegaRandomizerBagItem;
import sophisticated.building.systems.ServerBuildState;
import sophisticated.building.utilities.BlockEntry;
import sophisticated.building.utilities.BlockSet;
import sophisticated.building.utilities.InventoryHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractRandomizerBagItem
extends Item {
    private static final Map<Long, CachedPositionSelection> positionCache = new HashMap<Long, CachedPositionSelection>();
    private static long lastCacheTime = 0L;
    private static final int CACHE_DURATION_TICKS = 40;

    public AbstractRandomizerBagItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public abstract int getInventorySize();

    public abstract MenuProvider getContainerProvider(ItemStack var1);

    @Nullable
    public IItemHandler getBagInventory(ItemStack bag) {
        return (IItemHandler)bag.getCapability(Capabilities.ItemHandler.ITEM, null);
    }

    public List<ItemStack> getTemplates(IItemHandler bagInventory) {
        ArrayList<ItemStack> templates = new ArrayList<ItemStack>();
        if (bagInventory == null) {
            return templates;
        }
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            templates.add(stack.copy());
        }
        return templates;
    }

    public ItemStack pickRandomTemplateFresh(IItemHandler bagInventory, @Nullable Player player) {
        ItemStack bagStack;
        Item item;
        if (bagInventory == null) {
            return ItemStack.EMPTY;
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.isEmpty() || player != null && !player.isCreative() && InventoryHelper.findTotalItemsInInventory(player, stack.getItem()) <= 0) continue;
            slots.add(i);
        }
        if (slots.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (this instanceof OmegaRandomizerBagItem && player != null && (item = (bagStack = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem()) instanceof OmegaRandomizerBagItem) {
            OmegaRandomizerBagItem omegaBag = (OmegaRandomizerBagItem)item;
            int selectedSlot = this.pickWeightedSlot(slots, omegaBag, bagStack);
            return bagInventory.getStackInSlot(selectedSlot).copy();
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(slots.size());
        return bagInventory.getStackInSlot(((Integer)slots.get(randomIndex)).intValue()).copy();
    }

    public ItemStack pickRandomTemplateForPosition(IItemHandler bagInventory, BlockPos pos, @Nullable Player player) {
        int selectedSlot;
        long posKey;
        CachedPositionSelection cached;
        if (bagInventory == null) {
            return ItemStack.EMPTY;
        }
        ArrayList<Integer> availableSlots = new ArrayList<Integer>();
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.isEmpty() || player != null && !player.isCreative() && InventoryHelper.findTotalItemsInInventory(player, stack.getItem()) <= 0) continue;
            availableSlots.add(i);
        }
        if (availableSlots.isEmpty()) {
            return ItemStack.EMPTY;
        }
        long currentTime = System.currentTimeMillis() / 50L;
        if (currentTime - lastCacheTime >= 40L) {
            positionCache.clear();
            lastCacheTime = currentTime;
        }
        if ((cached = positionCache.get(posKey = pos.asLong())) != null && availableSlots.contains(cached.slotIndex)) {
            return bagInventory.getStackInSlot(cached.slotIndex).copy();
        }
        if (this instanceof OmegaRandomizerBagItem && player != null) {
            ItemStack bagStack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item item = bagStack.getItem();
            if (item instanceof OmegaRandomizerBagItem) {
                OmegaRandomizerBagItem omegaBag = (OmegaRandomizerBagItem)item;
                posRandom = new Random(posKey ^ lastCacheTime);
                selectedSlot = this.pickWeightedSlotWithRandom(availableSlots, omegaBag, bagStack, posRandom);
            } else {
                posRandom = new Random(posKey ^ lastCacheTime);
                int randomIndex = posRandom.nextInt(availableSlots.size());
                selectedSlot = (Integer)availableSlots.get(randomIndex);
            }
        } else {
            Random posRandom = new Random(posKey ^ lastCacheTime);
            int randomIndex = posRandom.nextInt(availableSlots.size());
            selectedSlot = (Integer)availableSlots.get(randomIndex);
        }
        positionCache.put(posKey, new CachedPositionSelection(selectedSlot, currentTime));
        return bagInventory.getStackInSlot(selectedSlot).copy();
    }

    public ItemStack pickRandomTemplate(IItemHandler bagInventory, @Nullable Player player) {
        return this.pickRandomTemplateFresh(bagInventory, player);
    }

    public ItemStack pickRandomStackCachedForPosition(IItemHandler bagInventory, BlockPos pos, @Nullable Player player) {
        return this.pickRandomTemplateForPosition(bagInventory, pos, player);
    }

    public ItemStack pickRandomStackCached(IItemHandler bagInventory, ItemStack bagItem, @Nullable Player player) {
        return this.pickRandomTemplateFresh(bagInventory, player);
    }

    public ItemStack pickAndConsumeFromInventory(IItemHandler bagInventory, Player player) {
        ItemStack template;
        if (bagInventory == null) {
            return ItemStack.EMPTY;
        }
        ArrayList<ItemStack> availableTemplates = new ArrayList<ItemStack>();
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            template = bagInventory.getStackInSlot(i);
            if (template.isEmpty() || !player.isCreative() && InventoryHelper.findTotalItemsInInventory(player, template.getItem()) <= 0) continue;
            availableTemplates.add(template);
        }
        if (availableTemplates.isEmpty()) {
            if (!player.level().isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"Missing blocks in inventory for randomizer bag!").withStyle(ChatFormatting.RED), true);
            }
            return ItemStack.EMPTY;
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(availableTemplates.size());
        template = (ItemStack)availableTemplates.get(randomIndex);
        if (!player.isCreative()) {
            InventoryHelper.removeFromInventory(player, template.getItem(), 1);
        }
        return template.copy();
    }

    public Set<Item> getMissingItems(IItemHandler bagInventory, Player player) {
        HashSet<Item> missing = new HashSet<Item>();
        if (bagInventory == null || player.isCreative()) {
            return missing;
        }
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack template = bagInventory.getStackInSlot(i);
            if (template.isEmpty() || InventoryHelper.findTotalItemsInInventory(player, template.getItem()) > 0) continue;
            missing.add(template.getItem());
        }
        return missing;
    }

    public ItemStack findStack(IItemHandler bagInventory, Item item) {
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.isEmpty() || stack.getItem() != item) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction facing = ctx.getClickedFace();
        ItemStack item = ctx.getItemInHand();
        Vec3 hitVec = ctx.getClickLocation();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (ctx.getPlayer() != null && ctx.getPlayer().isShiftKeyDown()) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            player.openMenu(this.getContainerProvider(item));
        } else {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!ServerBuildState.isLikeVanilla(player)) {
                return InteractionResult.FAIL;
            }
            ItemStack bag = ctx.getItemInHand();
            IItemHandler bagInventory = this.getBagInventory(bag);
            if (bagInventory == null) {
                return InteractionResult.FAIL;
            }
            ItemStack toPlace = this.pickAndConsumeFromInventory(bagInventory, player);
            if (toPlace.isEmpty()) {
                return InteractionResult.FAIL;
            }
            BlockPlaceContext blockItemUseContext = new BlockPlaceContext(new UseOnContext(player, ctx.getHand(), new BlockHitResult(hitVec, facing, pos, false)));
            if (!world.getBlockState(pos).canBeReplaced(blockItemUseContext)) {
                pos = pos.relative(facing);
            }
            BlockState blockState = Block.byItem((Item)toPlace.getItem()).getStateForPlacement(blockItemUseContext);
            BlockEntry blockEntry = new BlockEntry(pos, blockState, toPlace.getItem());
            BlockSet blockSet = new BlockSet(List.of(blockEntry), pos, pos, false);
            SophisticatedBuilding.SERVER_BLOCK_PLACER.applyBlockSet(player, blockSet);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack bag = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (world.isClientSide) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)bag);
            }
        } else {
            IItemHandler bagInventory = this.getBagInventory(bag);
            if (bagInventory == null) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)bag);
            }
            ItemStack toUse = this.pickRandomTemplate(bagInventory, player);
            if (toUse.isEmpty()) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)bag);
            }
            return toUse.use(world, player, hand);
        }
        player.openMenu(this.getContainerProvider(bag));
        return new InteractionResultHolder(InteractionResult.PASS, (Object)bag);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Put blocks in bag as " + String.valueOf(ChatFormatting.YELLOW) + "templates")));
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Blocks are consumed from " + String.valueOf(ChatFormatting.GREEN) + "inventory")));
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "Rightclick" + String.valueOf(ChatFormatting.GRAY) + " to place a random block")));
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "Sneak + rightclick" + String.valueOf(ChatFormatting.GRAY) + " to open inventory")));
        if (this instanceof OmegaRandomizerBagItem) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + "Scroll wheel" + String.valueOf(ChatFormatting.GRAY) + " on slots to adjust weight")));
        }
    }

    private int pickWeightedSlot(List<Integer> availableSlots, OmegaRandomizerBagItem omegaBag, ItemStack bagStack) {
        return this.pickWeightedSlotWithRandom(availableSlots, omegaBag, bagStack, ThreadLocalRandom.current());
    }

    private int pickWeightedSlotWithRandom(List<Integer> availableSlots, OmegaRandomizerBagItem omegaBag, ItemStack bagStack, Random random) {
        int totalWeight = 0;
        for (int slot : availableSlots) {
            totalWeight += omegaBag.getSlotWeight(bagStack, slot);
        }
        if (totalWeight <= 0) {
            return availableSlots.get(random.nextInt(availableSlots.size()));
        }
        int randomValue = random.nextInt(totalWeight);
        int cumulativeWeight = 0;
        for (int slot : availableSlots) {
            if (randomValue >= (cumulativeWeight += omegaBag.getSlotWeight(bagStack, slot))) continue;
            return slot;
        }
        return availableSlots.get(availableSlots.size() - 1);
    }

    private static class CachedPositionSelection {
        int slotIndex;
        long tickTime;

        CachedPositionSelection(int slot, long time) {
            this.slotIndex = slot;
            this.tickTime = time;
        }
    }
}

