/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.item;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import sophisticated.building.gui.OmegaRandomizerBagContainer;
import sophisticated.building.item.AbstractRandomizerBagItem;

public class OmegaRandomizerBagItem
extends AbstractRandomizerBagItem {
    public static final int INV_SIZE = 54;
    private static final String WEIGHTS_TAG = "SlotWeights";
    private static final int DEFAULT_WEIGHT = 1;
    private static final int MIN_WEIGHT = 1;
    private static final int MAX_WEIGHT = 10;

    @Override
    public int getInventorySize() {
        return 54;
    }

    @Override
    public MenuProvider getContainerProvider(ItemStack bag) {
        return new ContainerProvider(bag);
    }

    public int getSlotWeight(ItemStack bag, int slotIndex) {
        if (slotIndex < 0 || slotIndex >= 54) {
            return 1;
        }
        CustomData customData = (CustomData)bag.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (customData.isEmpty()) {
            return 1;
        }
        CompoundTag tag = customData.copyTag();
        if (!tag.contains(WEIGHTS_TAG)) {
            return 1;
        }
        int[] weightsArray = tag.getIntArray(WEIGHTS_TAG);
        if (weightsArray.length <= slotIndex) {
            return 1;
        }
        return Math.max(1, Math.min(10, weightsArray[slotIndex]));
    }

    public void setSlotWeight(ItemStack bag, int slotIndex, int weight) {
        int[] weights;
        if (slotIndex < 0 || slotIndex >= 54) {
            return;
        }
        weight = Math.max(1, Math.min(10, weight));
        CustomData customData = (CustomData)bag.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (tag.contains(WEIGHTS_TAG)) {
            weights = tag.getIntArray(WEIGHTS_TAG);
            if (weights.length < 54) {
                int[] newWeights = new int[54];
                System.arraycopy(weights, 0, newWeights, 0, weights.length);
                for (int i = weights.length; i < 54; ++i) {
                    newWeights[i] = 1;
                }
                weights = newWeights;
            }
        } else {
            weights = new int[54];
            for (int i = 0; i < 54; ++i) {
                weights[i] = 1;
            }
        }
        weights[slotIndex] = weight;
        tag.putIntArray(WEIGHTS_TAG, weights);
        bag.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public int[] getAllWeights(ItemStack bag) {
        int[] weights = new int[54];
        for (int i = 0; i < 54; ++i) {
            weights[i] = this.getSlotWeight(bag, i);
        }
        return weights;
    }

    public static int getMinWeight() {
        return 1;
    }

    public static int getMaxWeight() {
        return 10;
    }

    public static int getDefaultWeight() {
        return 1;
    }

    public static class ContainerProvider
    implements MenuProvider {
        private final ItemStack bag;

        public ContainerProvider(ItemStack bag) {
            this.bag = bag;
        }

        public Component getDisplayName() {
            return Component.translatable((String)"item.sophisticatedbuilding.omega_randomizer_bag");
        }

        @Nullable
        public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
            return new OmegaRandomizerBagContainer(containerId, playerInventory, ((AbstractRandomizerBagItem)this.bag.getItem()).getBagInventory(this.bag));
        }
    }
}

