/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.item;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.attachment.PowerLevel;
import sophisticated.building.create.foundation.item.TooltipHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PowerLevelItem
extends Item {
    public PowerLevelItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        PowerLevel powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL);
        if (powerLevel != null) {
            if (powerLevel.canIncreasePowerLevel()) {
                if (!world.isClientSide) {
                    powerLevel.increasePowerLevel();
                    player.setData(SophisticatedBuilding.POWER_LEVEL, (Object)powerLevel);
                    SophisticatedBuilding.log(player, "Upgraded power level to " + powerLevel.getPowerLevel());
                    stack.shrink(1);
                    world.playSound((Player)null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f);
                    AttachmentHandler.syncToClient(player);
                }
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
            }
            if (!world.isClientSide) {
                SophisticatedBuilding.log(player, "Already reached maximum power level!");
                world.playSound((Player)null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        return super.use(world, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")), ChatFormatting.GRAY, ChatFormatting.GRAY));
        tooltip.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)"key.sophisticatedbuilding.upgrade_power_level"), ChatFormatting.BLUE, ChatFormatting.BLUE));
    }
}

