/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.item;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import sophisticated.building.CommonConfig;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.attachment.AttachmentHandler;
import sophisticated.building.attachment.PowerLevel;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReachUpgrade2Item
extends Item {
    public ReachUpgrade2Item() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        PowerLevel powerLevel = (PowerLevel)player.getData(SophisticatedBuilding.POWER_LEVEL);
        if (powerLevel != null) {
            int currentLevel = powerLevel.getPowerLevel();
            if (currentLevel == 1) {
                if (!world.isClientSide) {
                    powerLevel.increasePowerLevel();
                    SophisticatedBuilding.log(player, "Upgraded power level to " + powerLevel.getPowerLevel());
                    stack.shrink(1);
                    world.playSound((Player)null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f);
                    AttachmentHandler.syncToClient(player);
                }
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
            }
            if (currentLevel < 1) {
                if (!world.isClientSide) {
                    SophisticatedBuilding.log(player, "Use Reach Upgrade 1 first.");
                    world.playSound((Player)null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (currentLevel > 1 && !world.isClientSide) {
                SophisticatedBuilding.log(player, "Already used this upgrade! Current power level is " + powerLevel.getPowerLevel() + ".");
                world.playSound((Player)null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Consume to increase reach to " + String.valueOf(ChatFormatting.BLUE) + String.valueOf(CommonConfig.reach.level2.get()))));
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Previous upgrades need to be consumed first")));
    }
}

