/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.item;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class SingleItemLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<SingleItemLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(instance -> SingleItemLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance)), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("item").forGetter(m -> m.stack))).apply((Applicative)instance, SingleItemLootModifier::new)));
    private final float chance;
    private final ItemStack stack;

    public SingleItemLootModifier(LootItemCondition[] conditionsIn, float chance, ItemStack stack) {
        super(conditionsIn);
        this.chance = chance;
        this.stack = stack;
    }

    @NotNull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.getRandom().nextFloat() < this.chance) {
            generatedLoot.add((Object)this.stack.copy());
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

