/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.item.upgrade;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.item.upgrade.BuildingUpgradeItem;
import sophisticated.building.item.upgrade.BuildingUpgradeWrapper;
import sophisticated.building.network.message.BackpackItemCountPacket;

public class BuildingUpgradeHelper {
    @Nullable
    public static BuildingUpgradeWrapper findBestBuildingUpgrade(Player player) {
        BuildingUpgradeWrapper bestWrapper = null;
        int bestTier = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            BuildingUpgradeWrapper wrapper = BuildingUpgradeHelper.getBuildingUpgradeFromBackpack(stack);
            if (wrapper == null || !wrapper.isEnabled() || wrapper.getTier() <= bestTier) continue;
            bestWrapper = wrapper;
            bestTier = wrapper.getTier();
        }
        return bestWrapper;
    }

    @Nullable
    public static BuildingUpgradeWrapper getBuildingUpgradeFromBackpack(ItemStack backpackStack) {
        if (backpackStack.isEmpty() || !(backpackStack.getItem() instanceof BackpackItem)) {
            return null;
        }
        try {
            IBackpackWrapper wrapper = BackpackWrapper.fromStack((ItemStack)backpackStack);
            if (wrapper == null) {
                return null;
            }
            UpgradeHandler upgradeHandler = wrapper.getUpgradeHandler();
            List wrappers = upgradeHandler.getTypeWrappers(BuildingUpgradeItem.TYPE);
            if (!wrappers.isEmpty()) {
                return (BuildingUpgradeWrapper)wrappers.getFirst();
            }
        }
        catch (Exception e) {
            SophisticatedBuilding.logger.debug("Error checking backpack for building upgrade: {}", (Object)e.getMessage());
        }
        return null;
    }

    public static int getMaxBlocksForPlayer(Player player) {
        BuildingUpgradeWrapper wrapper = BuildingUpgradeHelper.findBestBuildingUpgrade(player);
        return wrapper != null ? wrapper.getMaxBlocks() : 0;
    }

    public static ItemStack extractBlockFromBackpack(Player player, ItemStack blockItem, int amount, boolean simulate) {
        BuildingUpgradeWrapper wrapper = BuildingUpgradeHelper.findBestBuildingUpgrade(player);
        if (wrapper != null) {
            int toExtract;
            int maxFromUpgrade = wrapper.getMaxBlocks();
            int n = toExtract = maxFromUpgrade > 0 ? Math.min(amount, maxFromUpgrade) : 0;
            if (toExtract <= 0) {
                return ItemStack.EMPTY;
            }
            ItemStack extracted = wrapper.extractItem(blockItem, toExtract, simulate);
            if (!simulate && !extracted.isEmpty() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int remaining = wrapper.countItem(blockItem);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new BackpackItemCountPacket(BuiltInRegistries.ITEM.getKey((Object)blockItem.getItem()), remaining), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return extracted;
        }
        return ItemStack.EMPTY;
    }

    public static int countBlockInBackpack(Player player, ItemStack blockItem) {
        BuildingUpgradeWrapper wrapper = BuildingUpgradeHelper.findBestBuildingUpgrade(player);
        if (wrapper != null) {
            return wrapper.countItem(blockItem);
        }
        return 0;
    }

    public static void syncItemCount(ServerPlayer player, Item item) {
        BuildingUpgradeWrapper wrapper = BuildingUpgradeHelper.findBestBuildingUpgrade((Player)player);
        int count = 0;
        if (wrapper != null) {
            count = wrapper.countItem(new ItemStack((ItemLike)item));
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BackpackItemCountPacket(BuiltInRegistries.ITEM.getKey((Object)item), count), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static boolean hasBuildingUpgrade(Player player) {
        return BuildingUpgradeHelper.findBestBuildingUpgrade(player) != null;
    }

    public static int getBuildingUpgradeTier(Player player) {
        BuildingUpgradeWrapper wrapper = BuildingUpgradeHelper.findBestBuildingUpgrade(player);
        return wrapper != null ? wrapper.getTier() : 0;
    }
}

