/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.item.upgrade;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import sophisticated.building.item.upgrade.BuildingUpgradeWrapper;

public class BuildingUpgradeItem
extends UpgradeItemBase<BuildingUpgradeWrapper> {
    public static final UpgradeType<BuildingUpgradeWrapper> TYPE = new UpgradeType(BuildingUpgradeWrapper::new);
    public static final UpgradeGroup UPGRADE_GROUP = new UpgradeGroup("building_upgrades", TranslationHelper.INSTANCE.translUpgradeGroup("building_upgrades"));
    private static final IUpgradeCountLimitConfig LIMIT_CONFIG = new IUpgradeCountLimitConfig(){

        public int getMaxUpgradesPerStorage(String storageType, @Nullable ResourceLocation upgradeRegistryName) {
            return 1;
        }

        public int getMaxUpgradesInGroupPerStorage(String storageType, UpgradeGroup upgradeGroup) {
            return 1;
        }
    };
    private final int tier;
    private final int maxBlocks;

    public BuildingUpgradeItem(int tier, int maxBlocks) {
        super(LIMIT_CONFIG);
        this.tier = tier;
        this.maxBlocks = maxBlocks;
    }

    public int getTier() {
        return this.tier;
    }

    public int getMaxBlocks() {
        return this.maxBlocks;
    }

    public UpgradeType<BuildingUpgradeWrapper> getType() {
        return TYPE;
    }

    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return List.of(new IUpgradeItem.UpgradeConflictDefinition(item -> item instanceof BuildingUpgradeItem, 0, TranslationHelper.INSTANCE.translError("add.building_upgrade_conflict", new Object[0]), TranslationHelper.INSTANCE.translError("add.building_upgrade_conflict", new Object[0])));
    }

    public UpgradeGroup getUpgradeGroup() {
        return UPGRADE_GROUP;
    }

    public int getUpgradesPerStorage(String storageType) {
        return 1;
    }

    public int getUpgradesInGroupPerStorage(String storageType) {
        return 1;
    }

    public Component getName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"item.sophisticatedbuilding.building_upgrade.tooltip", (Object[])new Object[]{this.maxBlocks}).withStyle(ChatFormatting.GRAY));
        if (this.tier == 5) {
            tooltip.add((Component)Component.translatable((String)"item.sophisticatedbuilding.building_upgrade.omega_tooltip").withStyle(ChatFormatting.GOLD));
        }
        tooltip.add((Component)Component.translatable((String)"item.sophisticatedbuilding.building_upgrade.backpack_tooltip").withStyle(ChatFormatting.DARK_GRAY));
    }

    public UpgradeSlotChangeResult canAddUpgradeTo(IStorageWrapper storageWrapper, ItemStack upgradeStack, boolean firstLevelStorage, boolean isClientSide) {
        UpgradeSlotChangeResult result = super.canAddUpgradeTo(storageWrapper, upgradeStack, firstLevelStorage, isClientSide);
        return result;
    }

    public UpgradeSlotChangeResult canRemoveUpgradeFrom(IStorageWrapper storageWrapper, boolean isClientSide) {
        return UpgradeSlotChangeResult.success();
    }

    public UpgradeSlotChangeResult canSwapUpgradeFor(ItemStack upgradeStackToPut, int upgradeSlot, IStorageWrapper storageWrapper, boolean isClientSide) {
        if (upgradeStackToPut.getItem() instanceof BuildingUpgradeItem) {
            return UpgradeSlotChangeResult.success();
        }
        return super.canSwapUpgradeFor(upgradeStackToPut, upgradeSlot, storageWrapper, isClientSide);
    }
}

