/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.item.upgrade;

import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import sophisticated.building.item.upgrade.BuildingUpgradeItem;

public class BuildingUpgradeWrapper
implements IUpgradeWrapper {
    private final IStorageWrapper storageWrapper;
    private final ItemStack upgrade;
    private final BuildingUpgradeItem upgradeItem;
    private final Consumer<ItemStack> upgradeSaveHandler;
    private boolean enabled = true;

    public BuildingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        this.storageWrapper = storageWrapper;
        this.upgrade = upgrade;
        this.upgradeItem = (BuildingUpgradeItem)upgrade.getItem();
        this.upgradeSaveHandler = upgradeSaveHandler;
        CustomData customData = (CustomData)upgrade.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (tag.contains("enabled")) {
            this.enabled = tag.getBoolean("enabled");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        CustomData customData = (CustomData)this.upgrade.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        tag.putBoolean("enabled", enabled);
        this.upgrade.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        this.save();
    }

    public ItemStack getUpgradeStack() {
        return this.upgrade;
    }

    public int getTier() {
        return this.upgradeItem.getTier();
    }

    public int getMaxBlocks() {
        return this.upgradeItem.getMaxBlocks();
    }

    public IStorageWrapper getStorageWrapper() {
        return this.storageWrapper;
    }

    public ItemStack extractItem(ItemStack item, int amount, boolean simulate) {
        if (!this.isEnabled()) {
            return ItemStack.EMPTY;
        }
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        int slots = inventoryHandler.getSlots();
        int extracted = 0;
        ItemStack result = ItemStack.EMPTY;
        for (int i = 0; i < slots && extracted < amount; ++i) {
            int toExtract;
            ItemStack extractedStack;
            ItemStack slotStack = inventoryHandler.getStackInSlot(i);
            if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)item) || (extractedStack = inventoryHandler.extractItem(i, toExtract = Math.min(amount - extracted, slotStack.getCount()), simulate)).isEmpty()) continue;
            if (result.isEmpty()) {
                result = extractedStack.copy();
            } else {
                result.grow(extractedStack.getCount());
            }
            extracted += extractedStack.getCount();
        }
        return result;
    }

    public int countItem(ItemStack item) {
        if (!this.isEnabled()) {
            return 0;
        }
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        int slots = inventoryHandler.getSlots();
        int count = 0;
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = inventoryHandler.getStackInSlot(i);
            if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)item)) continue;
            count += slotStack.getCount();
        }
        return count;
    }

    public boolean hasPlaceableBlocks() {
        if (!this.isEnabled()) {
            return false;
        }
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        int slots = inventoryHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = inventoryHandler.getStackInSlot(i);
            if (slotStack.isEmpty() || !(slotStack.getItem() instanceof BlockItem)) continue;
            return true;
        }
        return false;
    }

    private void save() {
        this.upgradeSaveHandler.accept(this.upgrade);
    }

    public boolean canBeDisabled() {
        return true;
    }

    public boolean hideSettingsTab() {
        return false;
    }
}

