/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.network.message;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.client.ClientBackpackItemCache;

public record BackpackItemCountPacket(ResourceLocation itemId, int count) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, BackpackItemCountPacket> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, BackpackItemCountPacket::itemId, (StreamCodec)ByteBufCodecs.INT, BackpackItemCountPacket::count, BackpackItemCountPacket::new);
    public static final CustomPacketPayload.Type<BackpackItemCountPacket> ID = new CustomPacketPayload.Type(SophisticatedBuilding.asResource("backpack_item_count"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(BackpackItemCountPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Item item = (Item)BuiltInRegistries.ITEM.get(packet.itemId());
                if (item != null) {
                    ClientBackpackItemCache.setCount(item, packet.count());
                }
            });
        }
    }
}

