/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.item.OmegaRandomizerBagItem;

public record OmegaBagWeightPacket(int slotIndex, int weight) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, OmegaBagWeightPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, OmegaBagWeightPacket::slotIndex, (StreamCodec)ByteBufCodecs.INT, OmegaBagWeightPacket::weight, OmegaBagWeightPacket::new);
    public static final CustomPacketPayload.Type<OmegaBagWeightPacket> ID = new CustomPacketPayload.Type(SophisticatedBuilding.asResource("omega_bag_weight"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(OmegaBagWeightPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                ItemStack heldItem;
                Item patt0$temp;
                Player player = context.player();
                if (player != null && (patt0$temp = (heldItem = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem()) instanceof OmegaRandomizerBagItem) {
                    OmegaRandomizerBagItem omegaBag = (OmegaRandomizerBagItem)patt0$temp;
                    omegaBag.setSlotWeight(heldItem, packet.slotIndex, packet.weight);
                }
            });
        }
    }
}

