/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.utilities.BlockSet;

public record ServerBreakBlocksPacket(BlockSet blocks) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, ServerBreakBlocksPacket> CODEC = CustomPacketPayload.codec(ServerBreakBlocksPacket::write, ServerBreakBlocksPacket::new);
    public static final CustomPacketPayload.Type<ServerBreakBlocksPacket> ID = new CustomPacketPayload.Type(SophisticatedBuilding.asResource("server_break_blocks"));

    public ServerBreakBlocksPacket(FriendlyByteBuf buf) {
        this(BlockSet.decode(buf));
    }

    public void write(FriendlyByteBuf buf) {
        BlockSet.encode(buf, this.blocks);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(ServerBreakBlocksPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    SophisticatedBuilding.SERVER_BLOCK_PLACER.breakBlocks((Player)player, packet.blocks());
                }
            }).exceptionally(e -> {
                context.disconnect((Component)Component.translatable((String)"sophisticatedbuilding.networking.server_break_blocks.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

