/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.utilities.BlockSet;

public record ServerPlaceBlocksPacket(BlockSet blocks, long placeTime) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, ServerPlaceBlocksPacket> CODEC = CustomPacketPayload.codec(ServerPlaceBlocksPacket::write, ServerPlaceBlocksPacket::new);
    public static final CustomPacketPayload.Type<ServerPlaceBlocksPacket> ID = new CustomPacketPayload.Type(SophisticatedBuilding.asResource("server_place_blocks"));

    public ServerPlaceBlocksPacket(FriendlyByteBuf buf) {
        this(BlockSet.decode(buf), buf.readLong());
    }

    public void write(FriendlyByteBuf buf) {
        BlockSet.encode(buf, this.blocks);
        buf.writeLong(this.placeTime);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(ServerPlaceBlocksPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    SophisticatedBuilding.SERVER_BLOCK_PLACER.placeBlocksDelayed((Player)player, packet.blocks(), packet.placeTime());
                }
            }).exceptionally(e -> {
                context.disconnect((Component)Component.translatable((String)"sophisticatedbuilding.networking.server_place_blocks.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

