/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sophisticated.building.ClientConfig;
import sophisticated.building.ClientEvents;
import sophisticated.building.SophisticatedBuilding;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.buildmode.BuildModeEnum;
import sophisticated.building.create.AllSpecialTextures;
import sophisticated.building.create.CreateClient;
import sophisticated.building.systems.BuilderChain;
import sophisticated.building.utilities.BlockEntry;
import sophisticated.building.utilities.BlockSet;

@OnlyIn(value=Dist.CLIENT)
public class BlockPreviews {
    private static final int MAX_PLACED_BLOCKS_ENTRIES = 50;
    private final List<PlacedBlocksEntry> placedBlocksList = new ArrayList<PlacedBlocksEntry>();
    private HashSet<BlockPos> coordinatesCache;
    private int lastBlocksSize = -1;

    public void onTick() {
        LocalPlayer player = Minecraft.getInstance().player;
        this.drawPlacedBlocks();
        this.drawLookAtPreview((Player)player);
        this.drawOutlineAtBreakPosition((Player)player);
    }

    public void drawPlacedBlocks() {
        if (((Boolean)ClientConfig.visuals.showBlockPreviews.get()).booleanValue()) {
            for (PlacedBlocksEntry placed2 : this.placedBlocksList) {
                int totalTime = placed2.breaking ? (Integer)ClientConfig.visuals.breakAnimationLength.get() : (Integer)ClientConfig.visuals.appearAnimationLength.get();
                if (totalTime <= 0) continue;
                float dissolve = ((float)ClientEvents.ticksInGame - placed2.time) / (float)totalTime;
                this.renderBlockPreviews(placed2.blocks, placed2.breaking, dissolve);
            }
        }
        this.placedBlocksList.removeIf(placed -> {
            int totalTime = placed.breaking ? (Integer)ClientConfig.visuals.breakAnimationLength.get() : (Integer)ClientConfig.visuals.appearAnimationLength.get();
            return placed.time + (float)totalTime < (float)ClientEvents.ticksInGame;
        });
    }

    public void drawLookAtPreview(Player player) {
        BlockSet blocks = SophisticatedBuildingClient.BUILDER_CHAIN.getBlocks();
        if (blocks.size() == 0) {
            return;
        }
        if (SophisticatedBuildingClient.BUILD_MODES.getBuildMode() == BuildModeEnum.DISABLED && blocks.size() == 1) {
            return;
        }
        if (SophisticatedBuildingClient.BUILDER_CHAIN.getBuildingState() == BuilderChain.BuildingState.IDLE && ((Boolean)ClientConfig.visuals.onlyShowBlockPreviewsWhenBuilding.get()).booleanValue() && blocks.size() == 1) {
            return;
        }
        int blockCount = blocks.size();
        int maxPreviews = (Integer)ClientConfig.visuals.maxBlockPreviews.get();
        BuilderChain.BuildingState state = SophisticatedBuildingClient.BUILDER_CHAIN.getPretendBuildingState();
        String outlineID = "single";
        if (blockCount > 1) {
            outlineID = blocks.firstPos;
        }
        if (state != BuilderChain.BuildingState.BREAKING) {
            if (((Boolean)ClientConfig.visuals.showBlockPreviews.get()).booleanValue() && blockCount < maxPreviews) {
                coordinates = blocks.getCoordinates();
                Outliner.getInstance().showCluster((Object)outlineID, coordinates).withFaceTexture((BindableTexture)AllSpecialTextures.CHECKERED).disableLineNormals().lineWidth(0.03125f).colored(new Color(1.0f, 1.0f, 1.0f, 1.0f));
            } else {
                coordinates = blocks.getCoordinates();
                Outliner.getInstance().showCluster((Object)outlineID, coordinates).withFaceTexture((BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).disableLineNormals().lineWidth(0.0625f).colored(new Color(1.0f, 1.0f, 1.0f, 1.0f));
            }
        } else {
            coordinates = blocks.getCoordinates();
            Outliner.getInstance().showCluster((Object)outlineID, coordinates).withFaceTexture((BindableTexture)AllSpecialTextures.THIN_CHECKERED).disableLineNormals().lineWidth(0.0625f).colored(new Color(0.8f, 0.1f, 0.1f, 1.0f));
        }
        if (state != BuilderChain.BuildingState.IDLE) {
            String msg;
            if (blockCount > 1000) {
                msg = blockCount + " blocks";
            } else {
                int minX = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxY = Integer.MIN_VALUE;
                int minZ = Integer.MAX_VALUE;
                int maxZ = Integer.MIN_VALUE;
                for (BlockEntry entry : blocks) {
                    BlockPos pos = entry.blockPos;
                    if (pos.getX() < minX) {
                        minX = pos.getX();
                    }
                    if (pos.getX() > maxX) {
                        maxX = pos.getX();
                    }
                    if (pos.getY() < minY) {
                        minY = pos.getY();
                    }
                    if (pos.getY() > maxY) {
                        maxY = pos.getY();
                    }
                    if (pos.getZ() < minZ) {
                        minZ = pos.getZ();
                    }
                    if (pos.getZ() <= maxZ) continue;
                    maxZ = pos.getZ();
                }
                BlockPos dim = new BlockPos(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
                Object dimensions = "(";
                if (dim.getX() > 1) {
                    dimensions = (String)dimensions + dim.getX() + "x";
                }
                if (dim.getZ() > 1) {
                    dimensions = (String)dimensions + dim.getZ() + "x";
                }
                if (dim.getY() > 1) {
                    dimensions = (String)dimensions + dim.getY() + "x";
                }
                if (((String)(dimensions = ((String)dimensions).substring(0, ((String)dimensions).length() - 1))).length() > 1) {
                    dimensions = (String)dimensions + ")";
                }
                msg = blockCount + " blocks " + (String)dimensions;
            }
            SophisticatedBuilding.log(player, msg, true);
        }
    }

    public void drawOutlineAtBreakPosition(Player player) {
        BlockState blockState;
        if (SophisticatedBuildingClient.BUILD_MODES.getBuildMode() == BuildModeEnum.DISABLED) {
            return;
        }
        BuilderChain builderChain = SophisticatedBuildingClient.BUILDER_CHAIN;
        BlockPos pos = builderChain.getStartPosForBreaking();
        if (pos == null) {
            return;
        }
        BuilderChain.AbilitiesState abilitiesState = builderChain.getAbilitiesState();
        if ((Boolean)ClientConfig.visuals.onlyShowBlockPreviewsWhenBuilding.get() != false ? abilitiesState == BuilderChain.AbilitiesState.NONE : abilitiesState != BuilderChain.AbilitiesState.CAN_BREAK) {
            return;
        }
        if (SophisticatedBuildingClient.BUILDER_CHAIN.getLookingAtNear() != null) {
            return;
        }
        AABB aabb = new AABB(pos);
        if (player.level().isLoaded(pos) && !(blockState = player.level().getBlockState(pos)).isAir()) {
            aabb = blockState.getShape((BlockGetter)player.level(), pos).bounds().move(pos);
        }
        Outliner.getInstance().showAABB((Object)"break", aabb).disableLineNormals().lineWidth(0.015625f).colored(0x222222);
    }

    protected void renderBlockPreviews(BlockSet blocks, boolean breaking, float dissolve) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int maxRenderDist = (Integer)ClientConfig.performance.previewRenderDistance.get();
        double maxRenderDistSq = maxRenderDist * maxRenderDist;
        Vec3 playerPos = player.position();
        for (BlockEntry blockEntry : blocks) {
            double distSq = playerPos.distanceToSqr((double)blockEntry.blockPos.getX() + 0.5, (double)blockEntry.blockPos.getY() + 0.5, (double)blockEntry.blockPos.getZ() + 0.5);
            if (distSq > maxRenderDistSq) continue;
            this.renderBlockPreview(blockEntry, breaking, dissolve, blocks.firstPos, blocks.lastPos);
        }
    }

    protected void renderBlockPreview(BlockEntry blockEntry, boolean breaking, float dissolve, BlockPos firstPos, BlockPos lastPos) {
        float baseScale;
        if (blockEntry.newBlockState == null) {
            return;
        }
        BlockPos blockPos = blockEntry.blockPos;
        BlockState blockState = blockEntry.newBlockState;
        float scale = baseScale = ((Double)ClientConfig.visuals.previewScale.get()).floatValue();
        float alpha = 0.7f;
        if (dissolve > 0.0f) {
            float animationLength = 0.8f;
            double firstToSecond = lastPos.distSqr((Vec3i)firstPos);
            double place = 0.0;
            if (firstToSecond > 0.5) {
                double placeFromFirst = firstPos.distSqr((Vec3i)blockPos) / firstToSecond;
                double placeFromSecond = lastPos.distSqr((Vec3i)blockPos) / firstToSecond;
                place = (placeFromFirst + (1.0 - placeFromSecond)) / 2.0;
            }
            float diff = dissolve - (float)(place *= (double)(1.0f - animationLength));
            float t = diff / animationLength;
            t = Mth.clamp((float)t, (float)0.0f, (float)1.0f);
            t = this.gain(t, 0.5f);
            if (!breaking) {
                scale = baseScale + t * 0.3f;
                alpha = 0.7f + t * 0.3f;
            } else {
                t = 1.0f - t;
                scale = baseScale + t * 0.5f;
                alpha = 0.7f + t * 0.3f;
            }
            alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        }
        CreateClient.GHOST_BLOCKS.showGhostState(blockPos, blockState).at(blockPos).alpha(alpha).scale(scale).colored(blockEntry.invalid ? Color.RED : Color.WHITE);
    }

    private float gain(float x, float k) {
        float a = (float)(0.5 * Math.pow(2.0 * ((double)x < 0.5 ? (double)x : 1.0 - (double)x), k));
        return (double)x < 0.5 ? a : 1.0f - a;
    }

    public void onBlocksPlaced(BlockSet blocks) {
        if (!((Boolean)ClientConfig.visuals.showBlockPreviews.get()).booleanValue()) {
            return;
        }
        if (blocks.size() <= 1 || blocks.size() > (Integer)ClientConfig.visuals.maxBlockPreviews.get()) {
            return;
        }
        if (this.placedBlocksList.size() >= 50) {
            this.placedBlocksList.remove(0);
        }
        this.placedBlocksList.add(new PlacedBlocksEntry(ClientEvents.ticksInGame, false, new BlockSet(blocks)));
        Outliner.getInstance().keep((Object)Pair.of((Object)blocks.firstPos, (Object)((Integer)ClientConfig.visuals.appearAnimationLength.get())));
    }

    public void onBlocksBroken(BlockSet blocks) {
        if (!((Boolean)ClientConfig.visuals.showBlockPreviews.get()).booleanValue()) {
            return;
        }
        if (blocks.size() <= 1 || blocks.size() > (Integer)ClientConfig.visuals.maxBlockPreviews.get()) {
            return;
        }
        if (this.placedBlocksList.size() >= 50) {
            this.placedBlocksList.remove(0);
        }
        this.placedBlocksList.add(new PlacedBlocksEntry(ClientEvents.ticksInGame, true, new BlockSet(blocks)));
        Outliner.getInstance().keep((Object)Pair.of((Object)blocks.firstPos, (Object)((Integer)ClientConfig.visuals.breakAnimationLength.get())));
    }

    private void sortOnDistanceToPlayer(List<BlockPos> coordinates, Player player) {
        Collections.sort(coordinates, (lhs, rhs) -> {
            double lhsDistanceToPlayer = Vec3.atLowerCornerOf((Vec3i)lhs).subtract(player.getEyePosition(1.0f)).lengthSqr();
            double rhsDistanceToPlayer = Vec3.atLowerCornerOf((Vec3i)rhs).subtract(player.getEyePosition(1.0f)).lengthSqr();
            return (int)Math.signum(lhsDistanceToPlayer - rhsDistanceToPlayer);
        });
    }

    public static class PlacedBlocksEntry {
        float time;
        boolean breaking;
        BlockSet blocks;

        public PlacedBlocksEntry(float time, boolean breaking, BlockSet blocks) {
            this.time = time;
            this.breaking = breaking;
            this.blocks = blocks;
        }
    }
}

