/*
 * Decompiled with CFR 0.152.
 */
package sophisticated.building.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.items.IItemHandler;
import sophisticated.building.SophisticatedBuildingClient;
import sophisticated.building.item.AbstractRandomizerBagItem;
import sophisticated.building.render.BuildRenderTypes;
import sophisticated.building.render.ModifierRenderer;
import sophisticated.building.systems.BuilderChain;
import sophisticated.building.utilities.InventoryHelper;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderHandler {
    private static final ByteBufferBuilder LEVEL_BUFFER = new ByteBufferBuilder(1536);
    private static final ByteBufferBuilder GUI_BUFFER = new ByteBufferBuilder(1536);
    private static final ByteBufferBuilder TEXT_BUFFER = new ByteBufferBuilder(1536);
    private static final ChatFormatting highlightColor = ChatFormatting.DARK_AQUA;
    private static final ChatFormatting normalColor = ChatFormatting.WHITE;
    private static final Component placingText = Component.literal((String)(String.valueOf(normalColor) + "Left-click to " + String.valueOf(highlightColor) + "cancel, " + String.valueOf(normalColor) + "Right-click to " + String.valueOf(highlightColor) + "place"));
    private static final Component breakingText = Component.literal((String)(String.valueOf(normalColor) + "Left-click to " + String.valueOf(highlightColor) + "break, " + String.valueOf(normalColor) + "Right-click to " + String.valueOf(highlightColor) + "cancel"));

    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        PoseStack ms = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((ByteBufferBuilder)LEVEL_BUFFER);
        ms.pushPose();
        ms.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        ModifierRenderer.render(ms, buffer);
        ms.popPose();
    }

    @SubscribeEvent
    public static void onRenderGuiEvent(RenderGuiEvent.Post event) {
        RenderHandler.renderSubText(event.getGuiGraphics());
        RenderHandler.drawStacks(event.getGuiGraphics());
        RenderHandler.drawRandomizerBagHUD(event.getGuiGraphics());
    }

    private static void renderSubText(GuiGraphics guiGraphics) {
        BuilderChain.BuildingState state = SophisticatedBuildingClient.BUILDER_CHAIN.getBuildingState();
        if (state == BuilderChain.BuildingState.IDLE) {
            return;
        }
        Component text = state == BuilderChain.BuildingState.PLACING ? placingText : breakingText;
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        Font font = mc.font;
        PoseStack ms = guiGraphics.pose();
        ms.pushPose();
        ms.translate((double)screenWidth / 2.0, (double)(screenHeight - 54), 0.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int l = font.width((FormattedText)text);
        guiGraphics.drawString(font, text, (int)((float)(-l / 2)), -4, -1, true);
        RenderSystem.disableBlend();
        ms.popPose();
    }

    private static void drawStacks(GuiGraphics guiGraphics) {
        BuilderChain.BuildingState state = SophisticatedBuildingClient.BUILDER_CHAIN.getBuildingState();
        if (state != BuilderChain.BuildingState.PLACING) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Map<Item, Integer> stacks = SophisticatedBuildingClient.ITEM_USAGE_TRACKER.total;
        if (player.isCreative() && stacks.size() <= 1) {
            return;
        }
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int x = screenWidth / 2 + 10;
        int y = screenHeight / 2 - 8;
        int i = 0;
        for (Map.Entry<Item, Integer> stack : stacks.entrySet()) {
            int missing;
            int total = stack.getValue();
            if (total - (missing = SophisticatedBuildingClient.ITEM_USAGE_TRACKER.getMissingCount(stack.getKey())) > 0) {
                RenderHandler.drawItemStack(guiGraphics, new ItemStack((ItemLike)stack.getKey(), total - missing), x + i * 20, y, false);
                ++i;
            }
            if (missing <= 0) continue;
            RenderHandler.drawItemStack(guiGraphics, new ItemStack((ItemLike)stack.getKey(), missing), x + i * 20, y, true);
            ++i;
        }
    }

    private static void drawItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y, boolean missing) {
        guiGraphics.renderItem(stack, x, y);
        PoseStack ms = guiGraphics.pose();
        ms.pushPose();
        Font font = Minecraft.getInstance().font;
        String text = String.valueOf(stack.getCount());
        ms.translate(0.0, 0.0, 200.0);
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.immediate((ByteBufferBuilder)TEXT_BUFFER);
        font.drawInBatch(text, (float)(x + 19 - 2 - font.width(text)), (float)(y + 6 + 3), (missing ? ChatFormatting.RED.getColor() : ChatFormatting.WHITE.getColor()).intValue(), true, ms.last().pose(), (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        multibuffersource$buffersource.endBatch();
        ms.popPose();
    }

    protected static VertexConsumer beginLines(MultiBufferSource.BufferSource renderTypeBuffer) {
        return renderTypeBuffer.getBuffer(BuildRenderTypes.LINES);
    }

    protected static void endLines(MultiBufferSource.BufferSource renderTypeBuffer) {
        renderTypeBuffer.endBatch();
    }

    protected static VertexConsumer beginPlanes(MultiBufferSource.BufferSource renderTypeBuffer) {
        return renderTypeBuffer.getBuffer(BuildRenderTypes.PLANES);
    }

    protected static void endPlanes(MultiBufferSource.BufferSource renderTypeBuffer) {
        renderTypeBuffer.endBatch();
    }

    private static void drawRandomizerBagHUD(GuiGraphics guiGraphics) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.isCreative()) {
            return;
        }
        ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        LinkedHashMap<Item, Integer> bundledCounts = new LinkedHashMap<Item, Integer>();
        Item item = heldItem.getItem();
        if (item instanceof AbstractRandomizerBagItem) {
            AbstractRandomizerBagItem bagItem = (AbstractRandomizerBagItem)item;
            IItemHandler bagInventory = bagItem.getBagInventory(heldItem);
            if (bagInventory == null) {
                return;
            }
            List<ItemStack> templates = bagItem.getTemplates(bagInventory);
            if (templates.isEmpty()) {
                return;
            }
            for (ItemStack template : templates) {
                Item item2 = template.getItem();
                int inventoryCount = InventoryHelper.findTotalItemsInInventory((Player)player, item2);
                bundledCounts.merge(item2, inventoryCount, Integer::max);
            }
        } else if (heldItem.getItem() instanceof BlockItem) {
            Item item3 = heldItem.getItem();
            int inventoryCount = InventoryHelper.findTotalItemsInInventory((Player)player, item3);
            bundledCounts.put(item3, inventoryCount);
        } else {
            return;
        }
        if (bundledCounts.isEmpty()) {
            return;
        }
        int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        int padding = 10;
        float scale = 0.75f;
        int itemSize = Math.round(16.0f * scale);
        int spacing = 8;
        int maxPerRow = 5;
        int totalItems = bundledCounts.size();
        int numRows = (int)Math.ceil((double)totalItems / (double)maxPerRow);
        int itemsInLastRow = totalItems % maxPerRow;
        if (itemsInLastRow == 0 && totalItems > 0) {
            itemsInLastRow = maxPerRow;
        }
        int i = 0;
        for (Map.Entry entry : bundledCounts.entrySet()) {
            Item item4 = (Item)entry.getKey();
            int count = (Integer)entry.getValue();
            int row = i / maxPerRow;
            int col = i % maxPerRow;
            int itemsInThisRow = row == numRows - 1 ? itemsInLastRow : maxPerRow;
            int rowWidth = itemsInThisRow * (itemSize + spacing) - spacing;
            int itemX = screenWidth - padding - rowWidth + col * (itemSize + spacing);
            int itemY = screenHeight - padding - (numRows - row) * (itemSize + spacing);
            RenderHandler.drawRandomizerHUDItem(guiGraphics, new ItemStack((ItemLike)item4), itemX, itemY, count, scale);
            ++i;
        }
    }

    private static String formatCount(int count) {
        String suffix;
        double value;
        if (count < 1000) {
            return String.valueOf(count);
        }
        if (count < 1000000) {
            value = (double)count / 1000.0;
            suffix = "k";
        } else if (count < 1000000000) {
            value = (double)count / 1000000.0;
            suffix = "m";
        } else {
            value = (double)count / 1.0E9;
            suffix = "b";
        }
        double rounded = (double)Math.round(value * 10.0) / 10.0;
        if (Math.abs(rounded - Math.rint(rounded)) < 1.0E-9) {
            return String.format(Locale.ROOT, "%.0f%s", rounded, suffix);
        }
        return String.format(Locale.ROOT, "%.1f%s", rounded, suffix);
    }

    private static void drawRandomizerHUDItem(GuiGraphics guiGraphics, ItemStack stack, int x, int y, int count, float scale) {
        PoseStack ms = guiGraphics.pose();
        ms.pushPose();
        ms.translate((float)x, (float)y, 0.0f);
        ms.scale(scale, scale, 1.0f);
        guiGraphics.renderItem(stack, 0, 0);
        Font font = Minecraft.getInstance().font;
        String text = RenderHandler.formatCount(count);
        ms.translate(0.0, 0.0, 200.0);
        MultiBufferSource.BufferSource multibuffersource = MultiBufferSource.immediate((ByteBufferBuilder)GUI_BUFFER);
        int color = count == 0 ? ChatFormatting.RED.getColor() : (count <= 31 ? ChatFormatting.YELLOW.getColor().intValue() : ChatFormatting.WHITE.getColor().intValue());
        font.drawInBatch(text, (float)(14 - font.width(text)), 9.0f, color, true, ms.last().pose(), (MultiBufferSource)multibuffersource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        multibuffersource.endBatch();
        ms.popPose();
    }
}

